/************************************************************************
* FILE:        hc_tclThermalSensorPanel.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display panel temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORPANEL_H_
#define HC_TCLTHERMALSENSORPANEL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPPANEL_AVAIL, dp_tclHeatCtrlDPPANEL_AVAIL_Develop,
		dp_tclHeatCtrlDPPANEL_MinTemp,
		dp_tclHeatCtrlDPPANEL_MaxTemp,
		dp_tclHeatCtrlDPPANEL_EmergencyHighTemp, dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPPANEL_HighTemp, dp_tclHeatCtrlDPPANEL_HighTemp_Develop,
		dp_tclHeatCtrlDPPANEL_High2WarmTemp, dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPPANEL_WarmTemp, dp_tclHeatCtrlDPPANEL_WarmTemp_Develop,
		dp_tclHeatCtrlDPPANEL_Warm2NormalTemp, dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPPANEL_Cold2NormalTemp, dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPPANEL_ColdTemp, dp_tclHeatCtrlDPPANEL_ColdTemp_Develop,
		dp_tclHeatCtrlDPPANEL_Low2ColdTemp, dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPPANEL_LowTemp, dp_tclHeatCtrlDPPANEL_LowTemp_Develop,
		dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp, dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPPANEL_CriticalLowTemp, dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop >
hc_tclThermalSensorPanel_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPPANEL_Statistics_MinTemp,
		dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp>
hc_tclThermalSensorPanel_Statistics;

class hc_tclThermalSensorPanel
: public hc_tclThermalSensor
, public hc_tclThermalSensorPanel_Config
, public hc_tclThermalSensorPanel_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorPanel();
	virtual ~hc_tclThermalSensorPanel();
};

#endif /* HC_TCLTHERMALSENSORPANEL_H_ */
