/************************************************************************
* FILE:        hc_tclThermalSensorIMX.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display IMX temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORIMX_H_
#define HC_TCLTHERMALSENSORIMX_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPIMX_AVAIL, dp_tclHeatCtrlDPIMX_AVAIL_Develop,
		dp_tclHeatCtrlDPIMX_MinTemp,
		dp_tclHeatCtrlDPIMX_MaxTemp,
		dp_tclHeatCtrlDPIMX_EmergencyHighTemp, dp_tclHeatCtrlDPIMX_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPIMX_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPIMX_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPIMX_HighTemp, dp_tclHeatCtrlDPIMX_HighTemp_Develop,
		dp_tclHeatCtrlDPIMX_High2WarmTemp, dp_tclHeatCtrlDPIMX_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPIMX_WarmTemp, dp_tclHeatCtrlDPIMX_WarmTemp_Develop,
		dp_tclHeatCtrlDPIMX_Warm2NormalTemp, dp_tclHeatCtrlDPIMX_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPIMX_Cold2NormalTemp, dp_tclHeatCtrlDPIMX_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPIMX_ColdTemp, dp_tclHeatCtrlDPIMX_ColdTemp_Develop,
		dp_tclHeatCtrlDPIMX_Low2ColdTemp, dp_tclHeatCtrlDPIMX_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPIMX_LowTemp, dp_tclHeatCtrlDPIMX_LowTemp_Develop,
		dp_tclHeatCtrlDPIMX_CriticalLow2LowTemp, dp_tclHeatCtrlDPIMX_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPIMX_CriticalLowTemp, dp_tclHeatCtrlDPIMX_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPIMX_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPIMX_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPIMX_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorIMX_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPIMX_Statistics_MinTemp,
		dp_tclHeatCtrlDPIMX_Statistics_MaxTemp>
hc_tclThermalSensorIMX_Statistics;

class hc_tclThermalSensorIMX
: public hc_tclThermalSensor
, public hc_tclThermalSensorIMX_Config
, public hc_tclThermalSensorIMX_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorIMX();
	virtual ~hc_tclThermalSensorIMX();
};

#endif /* HC_TCLTHERMALSENSORIMX_H_ */
