/************************************************************************
* FILE:        hc_tclThermalSensorGYRO.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display GYRO temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORGYRO_H_
#define HC_TCLTHERMALSENSORGYRO_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPGYRO_AVAIL, dp_tclHeatCtrlDPGYRO_AVAIL_Develop,
		dp_tclHeatCtrlDPGYRO_MinTemp,
		dp_tclHeatCtrlDPGYRO_MaxTemp,
		dp_tclHeatCtrlDPGYRO_EmergencyHighTemp, dp_tclHeatCtrlDPGYRO_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPGYRO_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPGYRO_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPGYRO_HighTemp, dp_tclHeatCtrlDPGYRO_HighTemp_Develop,
		dp_tclHeatCtrlDPGYRO_High2WarmTemp, dp_tclHeatCtrlDPGYRO_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPGYRO_WarmTemp, dp_tclHeatCtrlDPGYRO_WarmTemp_Develop,
		dp_tclHeatCtrlDPGYRO_Warm2NormalTemp, dp_tclHeatCtrlDPGYRO_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPGYRO_Cold2NormalTemp, dp_tclHeatCtrlDPGYRO_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPGYRO_ColdTemp, dp_tclHeatCtrlDPGYRO_ColdTemp_Develop,
		dp_tclHeatCtrlDPGYRO_Low2ColdTemp, dp_tclHeatCtrlDPGYRO_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPGYRO_LowTemp, dp_tclHeatCtrlDPGYRO_LowTemp_Develop,
		dp_tclHeatCtrlDPGYRO_CriticalLow2LowTemp, dp_tclHeatCtrlDPGYRO_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPGYRO_CriticalLowTemp, dp_tclHeatCtrlDPGYRO_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPGYRO_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPGYRO_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPGYRO_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorGYRO_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPGYRO_Statistics_MinTemp,
		dp_tclHeatCtrlDPGYRO_Statistics_MaxTemp>
hc_tclThermalSensorGYRO_Statistics;

class hc_tclThermalSensorGYRO
: public hc_tclThermalSensor
, public hc_tclThermalSensorGYRO_Config
, public hc_tclThermalSensorGYRO_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorGYRO();
	virtual ~hc_tclThermalSensorGYRO();
};

#endif /* HC_TCLTHERMALSENSORGYRO_H_ */
