/************************************************************************
* FILE:        hc_tclThermalSensorControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: classes to control all thermal sensors
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 02.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORCONTROL_H_
#define HC_TCLTHERMALSENSORCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_hc_tclThermalSensorControl.h"
#include "hc_tclThermalSensor_Types.h"

class hc_tclThermalSensor;
class I_hc_tclSimuMode;

class hc_tclThermalSensorControl : public I_hc_tclThermalSensorControl
{
public:
   // Constructors and destructors
   hc_tclThermalSensorControl(tVoid);
   hc_tclThermalSensorControl(const hc_tclAppMain* poMainAppl);
   virtual ~hc_tclThermalSensorControl();

   virtual const tChar* getName() const { return "hc_tclThermalSensorControl"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tenThermalState enGetMainState(tVoid){return m_enMainThermalState;};
   virtual tenThermalState enGetSensorState(tenThermalSensorID enSensorID);
   virtual tenThermalState enGetSensorStateLastValid(tenThermalSensorID enSensorID);
   virtual tS16Temperature tGetTemperature(tenThermalSensorID enSensorID);
   virtual tenTemperatureQualifier enGetTemperatureQualifier(tenThermalSensorID enSensorID);
   virtual tS16Temperature tGetTemperatureMinStatistics(tenThermalSensorID enSensorID);
   virtual tS16Temperature tGetTemperatureMaxStatistics(tenThermalSensorID enSensorID);
   virtual tU8 u8GetConfigAttenuationCycleTime(tenThermalSensorID enSensorID);
   virtual tU8 u8GetFANSpeed(tenThermalSensorID enSensorID);
   virtual tBool bIsEmergencyFunctionActive(tenThermalSensorID enSensorID, tenEmergencyFunctionID enFunction);

   static tBool bNotify(hc_tclThermalSensor* poSensor, tenThermalSensorID enSensorID);
   static tVoid vDenotify(tenThermalSensorID enSensorID);

protected:
   inline hc_tclThermalSensor* poGetThermalSensor(tenThermalSensorID enSensorID) const
   {
      if (enThermalSensorID_MAX > enSensorID)
         return m_poThermalSensors[enSensorID];
      return OSAL_NULL;
   };
   virtual tVoid vHandleMessage_NewThermalInfo(hc_tclBaseIf::TMsg &Msg);
   virtual tVoid vHandleMessage_LoadSettings(hc_tclBaseIf::TMsg &Msg);
   // trace command handler
   virtual tVoid vHandleTraceCmd_GetThermSensorState(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Simu_IF_FLAG(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Simu_IF_TEMP(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Simu_IF_STATE(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Set_STATE(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Set_LASTVALIDSTATE(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Config_SensorEnable(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_ConfigReset_SensorEnable(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Config_Threshold(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Config_Threshold_Reset(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Config_Attenuation_Cycletime(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Config_Attenuation_Cycletime_Reset(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Config_FanThreshold(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_Config_FanThreshold_Reset(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_GetAbstractSensorState(const tUChar* puchData);
   // MAIN thermal state
   tVoid vUpdate_MainThermalState(tBool &bMainThermalStateChanged);
   tenThermalState m_enMainThermalState;
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
   // references of all thermal sensors
   static hc_tclThermalSensor* m_poThermalSensors[enThermalSensorID_MAX];
   // prepared internal messages for service handler
   hc_tclBaseIf::TMsg m_msgSensorUpdate_SrvHdl;
   hc_tclBaseIf::TMsg m_msgSensorUpdate_SrvHdl_AUTOSAR;
   hc_tclBaseIf::TMsg m_msgEmergencyFunctionStates;
   hc_tclBaseIf::TMsg m_msgITCStates;
   hc_tclBaseIf::TMsg m_msgFANSpeed;
};


#endif /* HC_TCLTHERMALSENSORCONTROL_H_ */
