/************************************************************************
* FILE:        hc_tclThermalSensorCD.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display CD temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORCD_H_
#define HC_TCLTHERMALSENSORCD_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPCD_AVAIL, dp_tclHeatCtrlDPCD_AVAIL_Develop,
		dp_tclHeatCtrlDPCD_MinTemp,
		dp_tclHeatCtrlDPCD_MaxTemp,
		dp_tclHeatCtrlDPCD_EmergencyHighTemp, dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPCD_HighTemp, dp_tclHeatCtrlDPCD_HighTemp_Develop,
		dp_tclHeatCtrlDPCD_High2WarmTemp, dp_tclHeatCtrlDPCD_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPCD_WarmTemp, dp_tclHeatCtrlDPCD_WarmTemp_Develop,
		dp_tclHeatCtrlDPCD_Warm2NormalTemp, dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPCD_Cold2NormalTemp, dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPCD_ColdTemp, dp_tclHeatCtrlDPCD_ColdTemp_Develop,
		dp_tclHeatCtrlDPCD_Low2ColdTemp, dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPCD_LowTemp, dp_tclHeatCtrlDPCD_LowTemp_Develop,
		dp_tclHeatCtrlDPCD_CriticalLow2LowTemp, dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPCD_CriticalLowTemp, dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorCD_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPCD_Statistics_MinTemp,
		dp_tclHeatCtrlDPCD_Statistics_MaxTemp>
hc_tclThermalSensorCD_Statistics;

class hc_tclThermalSensorCD
: public hc_tclThermalSensor
, public hc_tclThermalSensorCD_Config
, public hc_tclThermalSensorCD_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorCD();
	virtual ~hc_tclThermalSensorCD();
};

#endif /* HC_TCLTHERMALSENSORCD_H_ */
