/************************************************************************
* FILE:         hc_tclThermalSensorCD.cpp
* PROJECT:
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display CD temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "hc_tclThermalSensorCD.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclThermalSensorCD.cpp.trc.h"
#endif

/*************************************************************************
*
* FUNCTION:    hc_tclThermalSensorCD()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorCD::hc_tclThermalSensorCD()
: hc_tclThermalSensor(enThermalSensorID_CDDRIVE)
, hc_tclThermalSensorCD_Config()
, hc_tclThermalSensorCD_Statistics()
{
   ETG_TRACE_USR4(("hc_tclThermalSensorCD() entered."));
   (tVoid)bNotifyAbstractSensor(enAbstractSensorID_DRIVE);

   // notification for emergency functions
   tenEmergencyFunctionID _enFunctionID = enEmergencyFunctionID_SystemShutdown;
   tenThermalState _enUpperState = enThermalState_EMERGENCYHIGH;
   tenThermalState _enLowerState = enThermalState_CRITICALLOW;
   (tVoid)bEFNotify(_enFunctionID, _enUpperState, _enLowerState);

   _enFunctionID = enEmergencyFunctionID_Attenuation;
   _enUpperState = enThermalState_WARM;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bEFNotify(_enFunctionID, _enUpperState, _enLowerState);

   _enFunctionID = enEmergencyFunctionID_CDDriveOff;
   _enUpperState = enThermalState_HIGH;
   _enLowerState = enThermalState_LOW;
   (tVoid)bEFNotify(_enFunctionID, _enUpperState, _enLowerState);

   // notification for ITCs
   tenITC_ID _enITC_ID = enITC_ID_SYSTEMCriticalHighTemp;
   _enUpperState = enThermalState_EMERGENCYHIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMHighTemp;
   _enUpperState = enThermalState_HIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMLowTemp;
   _enUpperState = enThermalState_UNAVAILABLE;
   _enLowerState = enThermalState_LOW;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMCriticalLowTemp;
   _enUpperState = enThermalState_UNAVAILABLE;
   _enLowerState = enThermalState_CRITICALLOW;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_CDCriticalHighTemp;
   _enUpperState = enThermalState_EMERGENCYHIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_CDHighTemp;
   _enUpperState = enThermalState_HIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_CDWarmTemp;
   _enUpperState = enThermalState_WARM;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);
}


/*************************************************************************
*
* FUNCTION:    ~hc_tclThermalSensorCD()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorCD::~hc_tclThermalSensorCD()
{
   ETG_TRACE_USR4(("~hc_tclThermalSensorCD() entered."));
}
