/************************************************************************
* FILE:        I_hc_tclThermalSensorControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to control all thermal sensors
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 02.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/


#ifndef I_HC_TCLTHERMALSENSORCONTROL_H_
#define I_HC_TCLTHERMALSENSORCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"

#include "hc_tclThermalSensor_Types.h"

// define for Message IDs

class I_hc_tclThermalSensorControl : public hc_tclBaseIf
{
public:
   // constructor
   I_hc_tclThermalSensorControl(tVoid);
   I_hc_tclThermalSensorControl(const hc_tclAppMain* poMainAppl) : hc_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_hc_tclThermalSensorControl(){};

   virtual const tChar* getIfName() const { return "I_hc_tclThermalSensorControl"; };

   virtual tenThermalState enGetMainState(tVoid) = 0;
   virtual tenThermalState enGetSensorState(tenThermalSensorID enSensorID) = 0;
   virtual tenThermalState enGetSensorStateLastValid(tenThermalSensorID enSensorID) = 0;
   virtual tS16Temperature tGetTemperature(tenThermalSensorID enSensorID) = 0;
   virtual tenTemperatureQualifier enGetTemperatureQualifier(tenThermalSensorID enSensorID) = 0;
   virtual tS16Temperature tGetTemperatureMinStatistics(tenThermalSensorID enSensorID) = 0;
   virtual tS16Temperature tGetTemperatureMaxStatistics(tenThermalSensorID enSensorID) = 0;
   virtual tU8 u8GetConfigAttenuationCycleTime(tenThermalSensorID enSensorID) = 0;
   virtual tU8 u8GetFANSpeed(tenThermalSensorID enSensorID) = 0;
   virtual tBool bIsEmergencyFunctionActive(tenThermalSensorID enSensorID, tenEmergencyFunctionID enFunction) = 0;
};

#endif /* I_HC_TCLTHERMALSENSORCONTROL_H_ */
