/************************************************************************
* FILE:        hc_tclITC_Types.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base types of all internal trouble codes
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLITC_TYPES_H_
#define HC_TCLITC_TYPES_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/*******************************************************************************
| internal trouble code enumerations
|-----------------------------------------------------------------------------*/
enum tenITC_ID
{
	enITC_ID_UNDEF = 0,
	enITC_ID_CDWarmTemp,
	enITC_ID_CDHighTemp,
	enITC_ID_CDCriticalHighTemp,
	enITC_ID_DVDWarmTemp,
	enITC_ID_DVDHighTemp,
	enITC_ID_DVDCriticalHighTemp,
	enITC_ID_SYSTEMHighTemp,
	enITC_ID_SYSTEMCriticalHighTemp,
	enITC_ID_SYSTEMLowTemp,
	enITC_ID_SYSTEMCriticalLowTemp,
	enITC_ID_DisplayHighTemp,
	enITC_ID_DisplayLowTemp,
	enITC_ID_DisplayCriticalLowTemp,
	enITC_ID_AmplifierHighTemp,
	enITC_ID_EMMC_CriticalHigh,
	enITC_ID_IMX_CriticalHigh,
	enITC_ID_DISPLAY_CriticalHigh,
	enITC_ID_AMPLIFIER_CriticalHigh,
	enITC_ID_MAX
};

const char* strGetITC_ID(tenITC_ID enITC_ID);
const char* strGetITC_Abbreviation(tenITC_ID enITC_ID);

/*******************************************************************************
| internal trouble code enumerations
|-----------------------------------------------------------------------------*/
enum tenITC_State
{
	enITC_State_DISABLED = 0,
	enITC_State_NoResult,
	enITC_State_Passed,
	enITC_State_Failed,
	enITC_State_MAX
};

const char* strGetITC_State(tenITC_State enITC_State);

/*******************************************************************************
| new ITC info of specified thermal sensor
|-----------------------------------------------------------------------------*/
struct tITCInfo_Internal
{
	tenThermalSensorID enSensorID : 8;      // internal thermal sensor ID
	tenITC_State aenITCState[enITC_ID_MAX];    // state of all ITCs
};

/*******************************************************************************
| update ITC state
|-----------------------------------------------------------------------------*/
struct tITCState_Internal
{
	tenITC_State enState[enITC_ID_MAX];
};

/*******************************************************************************
| thermal sensor ITC parameter
|-----------------------------------------------------------------------------*/
struct tITCInfo_TS
{
	tenThermalState enUpperState : 8; // upper thermal state to activate emergency function
	tenThermalState enLowerState : 8; // lower thermal state to activate emergency function
	tenITC_State enITCState : 8;      // current ITC state
};

#endif /* HC_TCLITC_TYPES_H_ */
