/************************************************************************
* FILE:        hc_tclITCControl.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class to control all internal trouble codes
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclITCControl.h"
#include "hc_tclITC.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclITCControl.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/
hc_tclITC* hc_tclITCControl::m_apoITC[enITC_ID_MAX];

/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*************************************************************************
*
* FUNCTION:    hc_tclITCControl()
*
* DESCRIPTION: constructor
*
* PARAMETER:   const hc_tclAppMain* poMainAppl: main - object of this application
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclITCControl::hc_tclITCControl(const hc_tclAppMain* poMainAppl)
: I_hc_tclITCControl(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclITCControl() entered."));
   // prepare update message for diaglog handler
   (tVoid)memset((tVoid*)&m_msgITCSrvHdl,OSAL_NULL,sizeof(m_msgITCSrvHdl));
   (tVoid)OSAL_szStringNCopy(m_msgITCSrvHdl.strClassName,
		   "Ihc_tclClientDiaglogIf", sizeof(m_msgITCSrvHdl.strClassName)-1);
   m_msgITCSrvHdl.eCmd = eUpdateITCState;
   for (tU16 _u16Idx = 0; (sizeof(m_msgITCSrvHdl.u.tITCState.enState)/sizeof(m_msgITCSrvHdl.u.tITCState.enState[0])) > _u16Idx; ++_u16Idx)
   {
	   m_msgITCSrvHdl.u.tITCState.enState[_u16Idx] = enITC_State_NoResult;
   }
}

/*************************************************************************
*
* FUNCTION:    ~hc_tclITCControl()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclITCControl::~hc_tclITCControl()
{
   ETG_TRACE_USR4(("~hc_tclITCControl() entered."));

   for (tU8 _u8Index = 0; (tU8)enITC_ID_MAX > _u8Index; ++_u8Index)
   {
	   if (OSAL_NULL != m_apoITC[_u8Index])
		   OSAL_DELETE m_apoITC[_u8Index];
	   m_apoITC[_u8Index] = OSAL_NULL;
   }
}

/*************************************************************************
*
* FUNCTION:    vHandleMessage()
*
* DESCRIPTION: handle internal message
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg: reference of internal message
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclITCControl::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vHandleMessage(msg: %08x) entered.", pMsg ));
   HC_NULL_POINTER_CHECK(pMsg);
   switch (pMsg->eCmd)
   {
   case eNewITCState:
	   vHandleMessage_NewITCInfo(*pMsg);
	   break;
   default:
	   break;
   }
}

/*************************************************************************
*
* FUNCTION:    vHandleTraceMessage()
*
* DESCRIPTION: handle trace command
*
* PARAMETER:   const tUChar* puchData: reference of trace command data
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclITCControl::vHandleTraceMessage(const tUChar* puchData)
{
   ETG_TRACE_USR4(("vHandleTraceMessage(data: %08x) entered.", puchData ));
   HC_NULL_POINTER_CHECK(puchData);

   tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
   switch (u32MsgCode)
   {
   case FC_HEATCTRL_HC_GETITCSTATE:
	   {
		   vHandleTraceCmd_GetItcState(puchData);
	   }
	   break;
   default:
	   ETG_TRACE_USR4(("hc_tclITCControl::vHandleTraceMessage(): unhandled command %d.", u32MsgCode));
	   break;
   }
}

/*************************************************************************
*
* FUNCTION:    vGetReferences()
*
* DESCRIPTION: collect all references after instantiation
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclITCControl::vGetReferences()
{
   ETG_TRACE_USR4(("vGetReferences() entered."));
   // instantiate all ITC objects
   for (tU8 _u8Index = 0; (tU8)enITC_ID_MAX > _u8Index; ++_u8Index)
   {
	   m_apoITC[_u8Index] = OSAL_NEW hc_tclITC( (tenITC_ID)_u8Index );
   }

}

/*************************************************************************
*
* FUNCTION:    vStartCommunication()
*
* DESCRIPTION: handle communication start up
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclITCControl::vStartCommunication()
{
   ETG_TRACE_USR4(("vStartCommunication() entered."));
   HC_NULL_POINTER_CHECK(hc_tclAppMain::theServer());
   hc_tclAppMain::theServer()->vPostInternalMessage(&m_msgITCSrvHdl);
}

/*************************************************************************
*
* FUNCTION:    vTraceInfo()
*
* DESCRIPTION: trace status information
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclITCControl::vTraceInfo()
{
   ETG_TRACE_USR4(("vTraceInfo() entered."));
}

/*************************************************************************
*
* FUNCTION:    enGetITCState()
*
* DESCRIPTION: return the current state of specified ITC
*
* PARAMETER:   tenITC_ID enITC_ID
*
* RETURNVALUE: tenITC_State
*
*************************************************************************/
tenITC_State hc_tclITCControl::enGetITCState(tenITC_ID enITC_ID) const
{
   ETG_TRACE_USR4(("enGetITCState(ITC: %d) entered.", enITC_ID ));

   hc_tclITC* _poITC = poGetItc(enITC_ID);
   if (OSAL_NULL != _poITC)
	   return _poITC->enGetITCState();
   return enITC_State_DISABLED;
}

/*************************************************************************
*
* FUNCTION:    vHandleMessage_NewITCInfo()
*
* DESCRIPTION: handle new ITC information
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclITCControl::vHandleMessage_NewITCInfo(hc_tclBaseIf::TMsg &Msg)
{
   ETG_TRACE_USR4(("vHandleMessage_NewITCInfo() entered."));
   HC_NULL_POINTER_CHECK(hc_tclAppMain::theServer());
   tBool _bSrvHdlUpdateDone = FALSE;
   ETG_TRACE_USR1(("vHandleMessage_NewITCInfo: sensor %d", Msg.u.tITCInfo.enSensorID ));
   for (tU8 _u8ITC_ID=0; (tU8)enITC_ID_MAX > _u8ITC_ID; ++_u8ITC_ID )
   {
	   tenITC_ID _enITC_ID = (tenITC_ID)_u8ITC_ID;
	   hc_tclITC* _poITC = poGetItc(_enITC_ID);
	   tBool _bStateChanged = FALSE;
	   if (OSAL_NULL != _poITC)
	   {
		   ETG_TRACE_USR2(("vHandleMessage_NewITCInfo: itc[%d] = %d <-- %d", _u8ITC_ID, Msg.u.tITCInfo.aenITCState[_u8ITC_ID], _poITC->enGetITCState() ));
		   _poITC->vHandle_NewITCInfo(Msg.u.tITCInfo, _bStateChanged);
		   m_msgITCSrvHdl.u.tITCState.enState[_u8ITC_ID] = _poITC->enGetITCState();
	   }
	   else
	   {
		   ETG_TRACE_USR1(("vHandleMessage_NewITCInfo: itc[%d] = %d not instantiated", _u8ITC_ID, Msg.u.tITCInfo.aenITCState[_u8ITC_ID] ));
	   }
	   if (TRUE == _bStateChanged)
		   _bSrvHdlUpdateDone = TRUE;
   }
   if (TRUE == _bSrvHdlUpdateDone)
   {
	   // trigger sending of new test result
	   hc_tclAppMain::theServer()->vPostInternalMessage(&m_msgITCSrvHdl);
   }
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTraceCmd_GetItcState()
*
* DESCRIPTION: 	handler for trace command HC_GetItcState
*
* PARAMETER:   	const tUChar* puchData: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclITCControl::vHandleTraceCmd_GetItcState(const tUChar* puchData)
{
   ETG_TRACE_USR4(("vHandleTraceCmd_GetItcState() entered (data: 0x%08x).", puchData ));
   HC_NULL_POINTER_CHECK(puchData);

   //tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
   tU8 param1 = puchData[3];

   ETG_TRACE_FATAL(("%26s: HC_GetItcState %u",
		   "HC.APPL.ITC_.CMD__.START",
		   ETG_ENUM(HC_ItcID, param1) ));

   tenITC_ID _enITCID = (tenITC_ID)param1;
   hc_tclITC* _poITC = poGetItc(_enITCID);
   if (enITC_ID_MAX == _enITCID || enITC_ID_UNDEF == _enITCID)
   {
	   for (tU8 _u8SensorID = (tU8)enITC_ID_CDWarmTemp; (tU8)enITC_ID_MAX > _u8SensorID; ++_u8SensorID)
	   {
		   _enITCID = (tenITC_ID)_u8SensorID;
		   _poITC = poGetItc(_enITCID);
		   if (OSAL_NULL != _poITC)
			   _poITC->vTraceInfo();
	   }
	   ETG_TRACE_FATAL(("%26s: finished without errors",
			   "HC.APPL.ITC_.CMD__.RES__" ));
   }
   else if (OSAL_NULL != _poITC)
   {
	   _poITC->vTraceInfo();
	   ETG_TRACE_FATAL(("%26s: finished without errors",
			   "HC.APPL.ITC_.CMD__.RES__" ));
   }
   else
   {
	   ETG_TRACE_FATAL(("%26s: finished with errors",
			   "HC.APPL.ITC_.CMD__.RES__" ));
   }
}
