/************************************************************************
* FILE:        hc_tclITC.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of all internal trouble codes
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclITC.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclITC.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

// identifier of internal trouble code
const char* m_strITC_ID[enITC_ID_MAX] = {
		"UNDEF",
		"CDWarmTemp",
		"CDHighTemp",
		"CDCriticalHighTemp",
		"DVDWarmTemp",
		"DVDHighTemp",
		"DVDCriticalHighTemp",
		"SYSTEMHighTemp",
		"SYSTEMCriticalHighTemp",
		"SYSTEMLowTemp",
		"SYSTEMCriticalLowTemp",
		"DisplayHighTemp",
		"DisplayLowTemp",
		"DisplayCriticalLowTemp",
		"AmplifierHighTemp",
        "enITC_ID_EMMC_CriticalHigh",
		"enITC_ID_IMX_CriticalHigh",
		"enITC_ID_DISPLAY_CriticalHigh",
		"enITC_ID_AMPLIFIER_CriticalHigh",
};

const char* strGetITC_ID(tenITC_ID enITC_ID)
{
	if (enITC_ID_MAX > enITC_ID)
		return m_strITC_ID[enITC_ID];
	return m_strITC_ID[enITC_ID_UNDEF];
}


// abbreviation of internal trouble code
const char* m_strItcAbbreviation[enITC_ID_MAX] = {
		"UNDEF",
		"CDW__",
		"CDH__",
		"CDCH_",
		"DVDW_",
		"DVDH_",
		"DVDCH",
		"SYSH_",
		"SYSCH",
		"SYSL_",
		"SYSCL",
		"DISH_",
		"DISL_",
		"DISCL",
		"AMPH_",
		"EMMCCH",
		"IMXCH",
		"DISCH",
		"AMPCH"
};

const char* strGetITC_Abbreviation(tenITC_ID enITC_ID)
{
	ETG_TRACE_USR4(("strGetITC_Abbreviation."));
	if (enITC_ID_MAX > enITC_ID)
		return m_strItcAbbreviation[enITC_ID];
	return m_strItcAbbreviation[enITC_ID_UNDEF];
};

// states of internal trouble code
const char* m_strITC_State[enITC_State_MAX] = {
		"DISABLED",
		"NoResult",
		"Passed",
		"Failed"
};

const char* strGetITC_State(tenITC_State enITC_State)
{
	if (enITC_State_MAX > enITC_State)
		return m_strITC_State[enITC_State];
	return m_strITC_State[enITC_State_DISABLED];
}
/*******************************************************************************
*
* FUNCTION:    hc_tclITC()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclITC::hc_tclITC()
{
   ETG_TRACE_USR4(("hc_tclITC() entered."));
   m_enITC_ID = enITC_ID_UNDEF;
   m_enITCState = enITC_State_DISABLED;
   (tVoid)memset((tVoid*)m_aenITCState_TS, OSAL_NULL, sizeof(m_aenITCState_TS));
   for (tU16 _u16Idx = 0; (sizeof(m_aenITCState_TS)/sizeof(m_aenITCState_TS[0])) > _u16Idx; ++_u16Idx)
   {
	   m_aenITCState_TS[_u16Idx] = enITC_State_NoResult;
   }
}

/*******************************************************************************
*
* FUNCTION:    hc_tclITC()
*
* DESCRIPTION: constructor
*
* PARAMETER:   tenITC_ID enITC_ID
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclITC::hc_tclITC(tenITC_ID enITC_ID)
{
   ETG_TRACE_USR4(("hc_tclITC(id: %d) entered.", enITC_ID ));
   m_enITC_ID = enITC_ID;
   m_enITCState = enITC_State_DISABLED;
   (tVoid)memset((tVoid*)m_aenITCState_TS, OSAL_NULL, sizeof(m_aenITCState_TS));
   for (tU16 _u16Idx = 0; (sizeof(m_aenITCState_TS)/sizeof(m_aenITCState_TS[0])) > _u16Idx; ++_u16Idx)
   {
	   m_aenITCState_TS[_u16Idx] = enITC_State_NoResult;
   }
}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclITC()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclITC::~hc_tclITC()
{
   ETG_TRACE_USR4(("~hc_tclITC() entered."));
   (tVoid)memset((tVoid*)m_aenITCState_TS, OSAL_NULL, sizeof(m_aenITCState_TS));
}

/*******************************************************************************
*
* FUNCTION:    vTraceInfo()
*
* DESCRIPTION: trace status info
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclITC::vTraceInfo()
{
   ETG_TRACE_USR4(("vTraceInfo() entered."));
   tChar _strIdentStart[30] = "";
   sprintf(_strIdentStart, "HC.APPL.ITC_.%5s.START", strGetITC_Abbreviation(enGetITC_ID()));
   tChar _strIdentAttr[30] = "";
   sprintf(_strIdentAttr, "HC.APPL.ITC_.%5s.ATTR_", strGetITC_Abbreviation(enGetITC_ID()));
   tChar _strIdentEnd[30] = "";
   sprintf(_strIdentEnd, "HC.APPL.ITC_.%5s.END__", strGetITC_Abbreviation(enGetITC_ID()));

   // trace starting of trace block
   ETG_TRACE_USR2(("%026s: ", _strIdentStart ));
   vTraceInfo_ITC(_strIdentAttr);
   // trace ending of trace block
   ETG_TRACE_USR2(("%026s: ", _strIdentEnd ));

}

/*******************************************************************************
*
* FUNCTION:    vHandle_NewITCInfo()
*
* DESCRIPTION: handle new ITC information of specified thermal sensor
*
* PARAMETER:   tITCInfo_Internal &oInfo: new ITC information
*              tBool &bStateChanged:     ITC state changed <out>
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclITC::vHandle_NewITCInfo(const tITCInfo_Internal &oInfo, tBool &bStateChanged)
{
   ETG_TRACE_USR4(("vHandle_NewITCInfo() entered. sensor id :%d , itc state :%d , itc id : %d", ETG_CENUM (tenThermalSensorID,  oInfo.enSensorID ), ETG_CENUM(tenITC_State , oInfo.aenITCState[enGetITC_ID()] ), enGetITC_ID() ));
   tenThermalSensorID enSensorID = oInfo.enSensorID;
   if ((enGetITCState(enSensorID) != oInfo.aenITCState[enGetITC_ID()])
	   && (TRUE == bSetITCState(enSensorID, oInfo.aenITCState[enGetITC_ID()])))
   {
	    ETG_TRACE_USR4(("vHandle_NewITCInfo() entered. bSetITCState true " ));
	   tenITC_State _enITCState = enITC_State_DISABLED;
	   for (tU8 _u8SensorID = 0; (tU8)enThermalSensorID_MAX > _u8SensorID; ++_u8SensorID)
		   if (enGetITCState((tenThermalSensorID)_u8SensorID) > _enITCState)
		      _enITCState = enGetITCState((tenThermalSensorID)_u8SensorID);
	   bStateChanged = (enGetITCState() != _enITCState);
	   m_enITCState = _enITCState;
	   if (TRUE == bStateChanged)
		   vTraceInfo();
   }
   else
   {
	   ETG_TRACE_USR4(("vHandle_NewITCInfo() entered. bSetITCState false  " ));
   }
}

/*******************************************************************************
*
* FUNCTION:    vTraceInfo_ITC()
*
* DESCRIPTION: trace status info
*
* PARAMETER:   	const char* strIdentifier		trace identifier
*                                               like "HC_APPL.TSEN.GYRO_.ATTR_"
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclITC::vTraceInfo_ITC(const char* strIdentifier)
{
   ETG_TRACE_USR4(("vTraceInfo_ITC() entered."));

   ETG_TRACE_USR2(("%26s: %30s=%25s ",
		   strIdentifier,
		   "                NAME",
		   strGetITC_ID(enGetITC_ID()) ));
   ETG_TRACE_USR2(("%26s: %30s=%d ",
		   strIdentifier,
		   "                  ID",
		   enGetITC_ID() ));
   ETG_TRACE_USR2(("%26s: %30s=%25s ",
		   strIdentifier,
		   "               STATE",
		   strGetITC_State(enGetITCState()) ));
   for (tU8 _u8Index = 0; (tU8)enThermalSensorID_MAX > _u8Index; ++_u8Index)
   {
	   tChar _strAttrName[20] = "";
	   (tVoid)sprintf(_strAttrName, " TSEN_%5s_", strGetThermalSensorAbbreviation((tenThermalSensorID)_u8Index));

	   ETG_TRACE_USR2(("%26s: %20s%10s=%25s ",
			   strIdentifier,
			   _strAttrName,
			   "____NAME",
			   strGetThermalSensorID((tenThermalSensorID)_u8Index) ));
	   ETG_TRACE_USR2(("%26s: %20s%10s=%25s ",
			   strIdentifier,
			   _strAttrName,
			   "ITCSTATE",
			   strGetITC_State(enGetITCState((tenThermalSensorID)_u8Index)) ));
   }
}

