/*******************************************************************************
* FILE:        hc_tclFAN_Statistics.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*-------------------------------------------------------------------------------
*
* DESCRIPTION: class to manage statistical information of fan
*
*-------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 24.01.2017| CM-AI/EPB2 Bernard | init
*
*******************************************************************************/

#ifndef HC_TCLFAN_STATISTICS_H_
#define HC_TCLFAN_STATISTICS_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclFANControl_Types.h"

class hc_tclFAN_Statistics
{
public:
   // Constructors and destructors
   hc_tclFAN_Statistics(tVoid);
   virtual ~hc_tclFAN_Statistics();

   // trace info of FAN statistics
   tVoid vTraceInfo_FAN_Statistics(const char* strIdentifier) const;
   tVoid vTraceInfo_FAN_StatisticsComplete(const char* strIdentifier) const;

   // fan activation duration depending of specified fan control mode
   virtual tU32 u32GetActivationDuration(tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const;
   // fan activation counter depending of specified fan control mode
   virtual tU32 u32GetActivationCounter(tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const;
   // fan mode duration depending of specified fan control mode
   virtual tU32 u32GetModeDuration(tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const;
   // fan mode activation counter depending of specified fan control mode
   virtual tU32 u32GetModeActivationCounter(tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const;
   // update fan statistics
   tVoid vOnUpdateFANStatistics(tenFANCtrlMode enMode, tenFANPowerState enPwrState, tU8 u8Speed, tU16 u16Current);

protected:
   // increase fan activation duration depending of specified fan control mode
   virtual tS32 s32IncreaseActivationDuration(tenFANCtrlMode enMode, tU32 u32TmeDiff);
   // increase fan activation counter depending of specified fan control mode
   virtual tS32 s32IncreaseActivationCounter(tenFANCtrlMode enMode, tU32 u32Count);
   // increase fan mode duration depending of specified fan control mode
   virtual tS32 s32IncreaseModeDuration(tenFANCtrlMode enMode, tU32 u32TimeDiff);
   // fan mode activation counter depending of specified fan control mode
   virtual tS32 s32IncreaseModeActivationCounter(tenFANCtrlMode enMode, tU32 u32Count);
   // helper methods
   inline tBool bIsFanActive(tU8 u8Speed) const {return (1 <= u8Speed && 100 >= u8Speed);};
   // last information
   struct tLastInfo
   {
	   OSAL_tMSecond u32TimeStamp;
	   tenFANCtrlMode enFANCtrlMode;
	   tenFANPowerState enFANPowerState;
	   tU16 u16FANCurrent;
	   tU8 u8FANSpeed;
   } m_tLastInfo;
   // runtime statistical information
   struct tStatisticInfo
   {
	   tU32 u32ActivationDuration;
	   tU32 u32ActivationCounter;
	   tU32 u32ModeDuration;
	   tU32 u32ModeActivationCounter;
   } m_atStatisticInfo[enFANCtrlMode_MAX];
};

#endif /* HC_TCLFAN_STATISTICS_H_ */
