/*******************************************************************************
* FILE:        hc_tclFAN_Speed.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*-------------------------------------------------------------------------------
*
* DESCRIPTION: class to control fan speed
*
*-------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 28.07.2015| CM-AI/EPB2 Bernard | init
*
*******************************************************************************/

#ifndef HC_TCLFAN_SPEED_H_
#define HC_TCLFAN_SPEED_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclFANControl_Types.h"

class hc_tclFAN;
class I_hc_tclClientThermal;

class hc_tclFAN_Speed
{
public:
   // Constructors and destructors
   hc_tclFAN_Speed(tVoid);
   hc_tclFAN_Speed(hc_tclFAN* poFAN);
   virtual ~hc_tclFAN_Speed();

   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vStopCommunication();

   // returns FAN speed availability state
   inline tBool bGetFanSpeedAvail(tVoid) const {return bGetDevIFAvail();};
   // returns requested FAN speed
   inline tU8 u8GetFANSpeedReq(tVoid) const {return m_u8FANSpeedReq;};
   inline tU8 u8SetFANSpeedReq(tU8 u8Percent) { m_u8DevIFSpeedWriteCount = HC_FANCONTROL_FANSPEED_REWRITE_MAX_COUNT; m_u8FANSpeedReq = u8Percent; return u8GetFANSpeedReq();};
   inline tU8 u8SetFANSpeedReqStart(tU8 u8Percent) {return u8SetFANSpeedCur(u8Percent);};
   inline tU8 u8SetFANSpeedReq(tenThermalSensorID enSensorID, tU8 u8Percent) { return u8SetDevIFSpeed(enSensorID, u8Percent);};
   // returns confirmed FAN speed
   inline tU8 u8GetFANSpeedAck(tVoid) const {return ((OSAL_C_U8_MAX == m_u8FANSpeedAck)?u8GetFANSpeedCur():m_u8FANSpeedAck);};
   // returns current FAN speed
   inline tU8 u8GetFANSpeedCur(tVoid) const {return m_u8FANSpeedCur;};
   // set current FAN speed
   inline tU8 u8SetFANSpeedCur(tU8 u8Percent) {m_u8FANSpeedCur = u8Percent; return u8GetFANSpeedCur();};
   // returns configured upper step size of FAN speed
   inline tU8 u8GetConfigUpperStepSize(tVoid) const {return m_u8ConfigUpperStepSize;};
   // returns configured lower step size of FAN speed
   inline tU8 u8GetConfigLowerStepSize(tVoid) const {return m_u8ConfigLowerStepSize;};

   // supervision of FAN speed
   tVoid vMonitorFANSpeed(tVoid);

   // trace info of FAN Speed
   tVoid vTraceInfo_FANSpeed(const char* strIdentifier) const;

protected:
   // set confirmed FAN speed
   inline tU8 u8SetFANSpeedAck(tU8 u8Percent) {m_u8FANSpeedAck = u8Percent; return u8GetFANSpeedAck();};
   // FAN speed stepper
   tVoid vFANSpeedStepper(tVoid);
   // reference of own FAN
   hc_tclFAN* m_poFAN;
   // requested FAN speed
   tU8 m_u8FANSpeedReq;
   // confirmed FAN speed
   tU8 m_u8FANSpeedAck;
   // current FAN speed
   tU8 m_u8FANSpeedCur;
   // configured upper step size
   tU8 m_u8ConfigUpperStepSize;
   // configured lower step size
   tU8 m_u8ConfigLowerStepSize;

   // device interface availability state
   virtual tBool bGetDevIFAvail(tVoid) const;
   // write speed to device
   virtual tU8 u8SetDevIFSpeed(tU8 u8Speed) const;
   virtual tU8 u8SetDevIFSpeed(tenThermalSensorID enSensorID, tU8 u8Speed) const;
   // read speed from device
   virtual tU8 u8GetDevIFSpeed(tVoid) const;
   // reference of device interface
   I_hc_tclClientThermal* m_poDevIF;
   // write counts of unchanged speed
   tU8 m_u8DevIFSpeedWriteCount;
};

#endif /* HC_TCLFAN_SPEED_H_ */
