/*******************************************************************************
* FILE:        hc_tclFAN_Power.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*-------------------------------------------------------------------------------
*
* DESCRIPTION: class to control fan power state
* 			   !!! direct control !!!
*
*-------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 28.07.2015| CM-AI/EPB2 Bernard | init
*
*******************************************************************************/

#ifndef HC_TCLFAN_POWER_H_
#define HC_TCLFAN_POWER_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclFANControl_Types.h"

class hc_tclFAN;
class hc_tclFAN_Speed;

class hc_tclFAN_Power
{
public:
   // Constructors and destructors
   hc_tclFAN_Power(tVoid);
   hc_tclFAN_Power(hc_tclFAN* poFAN);
   virtual ~hc_tclFAN_Power();

   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vStopCommunication();

   // return FAN power control availability
   tBool bFanPowerAvail(tVoid) const;
   // return last requested FAN power state
   inline tenFANPowerState enGetPwrStateReq(tVoid) const {return m_enFANPwrStateReq;};
   // return last confirmed FAN power state
   inline tenFANPowerState enGetPwrStateAck(tVoid) const {return m_enFANPwrStateAck;};
   // set FAN power state and return the new requested state
   tenFANPowerState enSetPwrState(tenFANPowerState enState);

   // supervision of FAN power state
   tVoid vMonitorFANPwrState(tVoid);

   // trace info of FAN Power State
   tVoid vTraceInfo_FANPwrState(const char* strIdentifier) const;

protected:
   // last requested FAN power state
   inline tenFANPowerState enSetPwrStateAck(tBool bActive) {
	   if (TRUE == bActive)
		   m_enFANPwrStateAck = enFANPowerState_ON;
	   else
	   	   m_enFANPwrStateAck = enFANPowerState_OFF;
	   return enGetPwrStateAck();
   };
   // reference of own FAN
   hc_tclFAN* m_poFAN;
   // requested FAN power state
   tenFANPowerState m_enFANPwrStateReq;
   // last confirmed FAN power state
   tenFANPowerState m_enFANPwrStateAck;

   // reference of device interface
   hc_tclFAN_Speed* m_poDevIF;
};

#endif /* HC_TCLFAN_POWER_H_ */
