/************************************************************************
* FILE:        hc_tclFANControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class to control fan
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 22.04.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLFANCONTROL_H_
#define HC_TCLFANCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_hc_tclFANControl.h"
#include "hc_tclFANControl_Types.h"
#include "hc_tclFAN.h"
#include "hc_tclThermalSensor_Types.h"

class I_hc_tclSimuMode;
class I_hc_tclCfgMgr;

class hc_tclFANControl : public I_hc_tclFANControl
{
public:
   // Constructors and destructors
   hc_tclFANControl(tVoid);
   hc_tclFANControl(const hc_tclAppMain* poMainAppl);
   virtual ~hc_tclFANControl();

   virtual const tChar* getName() const { return "hc_tclFANControl"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vStopCommunication();
   virtual tVoid vTraceInfo();

   // getting state information of fan
   virtual tenFANCtrlMode enGetFANCtrlMode(tVoid) const {return enGetFANCtrlMode(enFANID_SYSTEM);};
   virtual tenFANCtrlMode enGetFANCtrlMode(tenFANID enFanID) const;
   virtual tenFANPowerState enGetFANPwrState(tVoid) const {return enGetFANPwrState(enFANID_SYSTEM);};
   virtual tenFANPowerState enGetFANPwrState(tenFANID enFanID) const;
   virtual tU8 u8GetFANSpeed(tVoid) const {return u8GetFANSpeed(enFANID_SYSTEM);};
   virtual tU8 u8GetFANSpeed(tenFANID enFanID) const;
   virtual tU16 u16GetFANCurrent(tVoid) const {return u16GetFANCurrent(enFANID_SYSTEM);};
   virtual tU16 u16GetFANCurrent(tenFANID enFanID) const;
   // getting ActivationDuration in [ms] depending of fan control mode and storage type for specified fan
   virtual tU32 u32GetActivationDuration(tenFANID enFanID, tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const;
   // getting ActivationCounter depending of fan control mode and storage type for specified fan
   virtual tU32 u32GetActivationCounter(tenFANID enFanID, tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const;

   // requested fan control state of system fan
   virtual tBool bSetReqFanControl(tenFANCtrlModeEvent enEvent, tenFANPowerState enPwrState,
		   tU8 u8Speed, tU8 u8SpeedStart)
   {
	   return bSetReqFanControl(enFANID_SYSTEM, enEvent, enPwrState, u8Speed, u8SpeedStart);
   };
   virtual tBool bSetReqFanControl(tenFANID enFanID, tenFANCtrlModeEvent enEvent,
		   tenFANPowerState enPwrState, tU8 u8Speed, tU8 u8SpeedStart);
protected:
   // fan object access
   hc_tclFAN* poGetFan(tenFANID enFanID) const;
   // configuration handling
   tBool bLoadConfig(tVoid);
   // timer handler
   static OSAL_tpfCallback cb_vTimerFanUpdate(tVoid* pArg);
   // attribute access
   inline tBool bGetEnable(tVoid) const {return m_bEnable;};
   inline OSAL_tTimerHandle hGetTimer(tVoid) const {return m_hTimerFanUpdate;};
   inline tU32 u32GetCycleTime(tVoid) const {return HC_FANCONTROL_CYCLETIME;};
   // trace info of FAN
   tVoid vTraceInfo_FANCONTROL(const char* strIdentifier) const;
   // trace command handler
   virtual tVoid vHandleTraceCmd_GetFanState(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_GetFanStatistics(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_SetFanReq(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_ConfigFanEnable(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_ConfigFanEnable_Reset(const tUChar* puchData);
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
   // configuration manager
   I_hc_tclCfgMgr* m_poCfgMgr;
   // all fan object references
   hc_tclFAN* m_apoFAN[enFANID_MAX];
   // system fan
   hc_tclFAN m_oFAN;
   // configuration
   tBool m_bEnable;
   tU8 m_u8EnableDevel;
   // sensor specific fan speeds
   tU8 m_au8SensorFanSpeed[enThermalSensorID_MAX];
   // cyclic timer
   OSAL_tTimerHandle m_hTimerFanUpdate;
   hc_tclBaseIf::TMsg m_oTriggerFanUpdate;
   hc_tclBaseIf::TMsg m_oUpdateFanState;
};

#endif /* HC_TCLFANCONTROL_H_ */
