/*******************************************************************************
* FILE:        hc_tclFAN.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*-------------------------------------------------------------------------------
*
* DESCRIPTION: class to control fan
*
*-------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 28.07.2015| CM-AI/EPB2 Bernard | init
*
*******************************************************************************/

#ifndef HC_TCLFAN_H_
#define HC_TCLFAN_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclFANControl_Types.h"
#include "hc_tclFAN_Statistics.h"

class hc_tclFANControl;
class hc_tclFAN_Power;
class hc_tclFAN_Speed;
class hc_tclFAN_Current;

class hc_tclFAN
: public hc_tclFAN_Statistics
{
public:
   // Constructors and destructors
   hc_tclFAN(tVoid);
   hc_tclFAN(hc_tclFANControl* poFANControl);
   virtual ~hc_tclFAN();

   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vStopCommunication();

   // supervision of FAN
   virtual tVoid vMonitorFAN(tVoid);

   // trace info of FAN
   tVoid vTraceInfo_FAN(const char* strIdentifier) const;

   // fan id
   tenFANID enGetFANID(tVoid) const {return m_enFANID;};
   // control mode
   virtual tenFANCtrlMode enGetControlMode(tVoid) const;
   virtual tenFANCtrlModeEvent enGetControlModeEvent(tVoid) const;
   virtual tU32 u32GetControlModeTimeIndex(tVoid) const;
   virtual tenFANCtrlModeState enGetControlModeState(tenFANCtrlMode enMode) const;
   inline tenFANCtrlModeState enGetControlModeState(tVoid) const {return enGetControlModeState(enGetControlMode());};
   virtual tU32 u32GetControlModeStateTimeIndex(tenFANCtrlMode enMode) const;
   inline tU32 u32GetControlModeStateTimeIndex(tVoid) const {return u32GetControlModeStateTimeIndex(enGetControlMode());};
   // power state
   inline hc_tclFAN_Power* poGetPower(tVoid) const {return m_poPower;};
   virtual tenFANPowerState enGetPowerState(tVoid) const;
   virtual tBool bIsPowerAvailable(tVoid) const;
   // speed
   inline hc_tclFAN_Speed* poGetSpeed(tVoid) const {return m_poSpeed;};
   virtual tU8 u8GetSpeed(tVoid) const;
   virtual tU8 u8GetSpeed(tenThermalSensorID enSensorID) const;
   virtual tBool bIsSpeedAvailable(tVoid) const;
   // current
   inline hc_tclFAN_Current* poGetCurrent(tVoid) const {return m_poCurrent;};
   virtual tU16 u16GetCurrent(tVoid) const;
   virtual tU16 u16GetCurrentAve(tVoid) const;
   virtual tBool bIsCurrentAvailable(tVoid) const;
   // request fan control state
   virtual tBool bSetReqFanControl(tenFANCtrlModeEvent enEvent, tenFANPowerState enPwrState,
		   tU8 u8Speed, tU8 u8SpeedStart = OSAL_C_U8_MAX);
   inline tenFANCtrlModeEvent enGetReqFanControlEvent(tVoid) const {return m_sControlModeInfo.enReqEvent;};
   virtual tBool bSetReqFanControl(tenFANCtrlMode enMode, tenFANPowerState enPwrState,
		   tU8 u8Speed, tU8 u8SpeedStart);
   virtual tBool bSetReqFanControl(tenThermalSensorID enSensorID, tenFANCtrlMode enMode,
		   tenFANPowerState enPwrState, tU8 u8Speed, tU8 u8SpeedStart);
   //
   virtual tenFANPowerState enGetReqFanPowerState(tenFANCtrlMode enMode) const;
   inline tenFANPowerState enGetReqFanPowerState(tVoid) const {return enGetReqFanPowerState(enGetControlMode());};
   virtual tU8 u8GetReqFanSpeed(tenFANCtrlMode enMode) const;
   inline tU8 u8GetReqFanSpeed(tVoid) const {return u8GetReqFanSpeed(enGetControlMode());};
   virtual tU8 u8GetReqFanSpeedStart(tenFANCtrlMode enMode) const;
   inline tU8 u8GetReqFanSpeedStart(tVoid) const {return u8GetReqFanSpeedStart(enGetControlMode());};

protected:
   // requested control mode event
   inline tenFANCtrlModeEvent enSetReqFanControlEvent(tenFANCtrlModeEvent enEvent){m_sControlModeInfo.enReqEvent = enEvent; return enGetReqFanControlEvent();};
   // requested fan power state
   virtual tenFANPowerState enSetReqFanPowerState(tenFANCtrlMode enMode, tenFANPowerState enPwrState);
   inline tenFANPowerState enSetReqFanPowerState(tenFANPowerState enPwrState) {return enSetReqFanPowerState(enGetControlMode(), enPwrState);};
   // requested fan speed
   virtual tU8 u8SetReqFanSpeed(tenFANCtrlMode enMode, tU8 u8Speed);
   inline tU8 u8SetReqFanSpeed(tU8 u8Speed) {return u8SetReqFanSpeed(enGetControlMode(), u8Speed);};
   virtual tU8 u8SetReqFanSpeedStart(tenFANCtrlMode enMode, tU8 u8Speed);
   inline tU8 u8SetReqFanSpeedStart(tU8 u8Speed) {return u8SetReqFanSpeedStart( enGetControlMode(), u8Speed);};
   virtual tU8 u8SetSpeed(tU8 u8Speed);
   virtual tU8 u8SetSpeedStart(tU8 u8Speed);
   // control mode
   virtual tenFANCtrlMode enGetControlMode(tenFANCtrlModeEvent enEvent) const;
   virtual tenFANCtrlMode enSetControlMode(tenFANCtrlMode enMode);
   virtual tenFANCtrlModeEvent enSetControlModeEvent(tenFANCtrlModeEvent enEvent);
   virtual tU32 u32SetControlModeTimeIndex(tU32 u32TimeIndex);
   // control mode state
   virtual tenFANCtrlModeState enSetControlModeState(tenFANCtrlMode enMode, tenFANCtrlModeState enState);
   inline tenFANCtrlModeState enSetControlModeState(tenFANCtrlModeState enState) {
	   return enSetControlModeState(enGetControlMode(), enState);
   };
   virtual tU32 u32SetControlModeStateTimeIndex(tenFANCtrlMode enMode, tU32 u32TimeIndex);
   inline tBool bSM_ControlMode_Looping(tU32 u32LoopCount, tenFANCtrlMode enPreviousMode) const {
	   if ((enPreviousMode != enGetControlMode()) && (0 == u32GetControlModeTimeIndex()) // mode change without time delay
		   && (HC_FANCONTROL_MAX_LOOPCOUNT > u32LoopCount))                              // no endless loop
		   return TRUE;
	   return FALSE;
   };
   inline tBool bSM_ControlModeState_Looping(tU32 u32LoopCount, tenFANCtrlMode enMode, tenFANCtrlModeState enPreviousState) const {
	   if ((enPreviousState != enGetControlModeState(enMode)) && (0 == u32GetControlModeStateTimeIndex(enMode)) // state change without time delay
		   && (enMode == enGetControlMode())                                                                    // no sporadic control mode change
		   && (enFANCtrlModeEvent_DOENTCARE == enGetControlModeEvent())                                         // no mode change requested
		   && (HC_FANCONTROL_MAX_LOOPCOUNT > u32LoopCount))                                                     // no endless loop
		   return TRUE;
	   return FALSE;
   }
   inline tU32 u32GetNextTimeIndex(tU32 u32TimeIndex) const {
	   if (0 < u32TimeIndex)
		   return --u32TimeIndex;
	   return 0;
   }
   virtual tVoid vSM_ControlMode(tVoid);
   virtual tVoid vSM_ControlMode_INIT(tVoid);
   virtual tVoid vSM_ControlMode_AUTO(tVoid);
   virtual tVoid vSM_ControlMode_AUTO_SELFTEST(tVoid);
   virtual tVoid vSM_ControlMode_AUTO_MEASURE(tVoid);
   virtual tVoid vSM_ControlMode_MANUAL(tVoid);
   virtual tVoid vSM_ControlMode_STOPPED(tVoid);
   virtual tVoid vHandle_ControlMode(tVoid);
   // reference of fan control
   hc_tclFANControl* m_poFANControl;
   // reference of FAN power state
   hc_tclFAN_Power* m_poPower;
   // reference of FAN speed
   hc_tclFAN_Speed* m_poSpeed;
   // reference of FAN current
   hc_tclFAN_Current* m_poCurrent;
   // fan id
   tenFANID m_enFANID;
   // FAN control mode information
   tFANCtrlModeInfo m_sControlModeInfo;
   // state information of all FAN control modes
   tFANCtrlModeStateInfo m_asControlModeStateInfo[enFANCtrlMode_MAX];
   // last measured current
   tU16 m_u16LastMeasuredCurrent;
   // sensor specific fan speeds
   tU8 m_au8SensorFanSpeed[enThermalSensorID_MAX];
};


#endif /* HC_TCLFAN_H_ */
