/************************************************************************
* FILE:        I_hc_tclFANControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to control fan
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 22.04.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_HC_TCLFANCONTROL_H_
#define I_HC_TCLFANCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclFANControl_Types.h"

class I_hc_tclFANControl : public hc_tclBaseIf
{
public:
   // constructor
   I_hc_tclFANControl(tVoid);
   I_hc_tclFANControl(const hc_tclAppMain* poMainAppl) : hc_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_hc_tclFANControl(){};

   virtual const tChar* getIfName() const { return "I_hc_tclFANControl"; };

   virtual tenFANCtrlMode enGetFANCtrlMode(tVoid) const = 0;
   virtual tenFANCtrlMode enGetFANCtrlMode(tenFANID enFanID) const = 0;
   virtual tenFANPowerState enGetFANPwrState(tVoid) const = 0;
   virtual tenFANPowerState enGetFANPwrState(tenFANID enFanID) const = 0;
   virtual tU8 u8GetFANSpeed(tenFANID enFanID) const = 0;
   virtual tU8 u8GetFANSpeed(tVoid) const = 0;
   virtual tU16 u16GetFANCurrent(tVoid) const = 0;
   virtual tU16 u16GetFANCurrent(tenFANID enFanID) const = 0;
   // getting ActivationDuration in [ms] depending of fan control mode and storage type for specified fan
   virtual tU32 u32GetActivationDuration(tenFANID enFanID, tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const = 0;
   // getting ActivationCounter depending of fan control mode and storage type for specified fan
   virtual tU32 u32GetActivationCounter(tenFANID enFanID, tenFANCtrlMode enMode, tenFANStatisticStorageType enStorageType) const = 0;

   virtual tBool bSetReqFanControl(tenFANCtrlModeEvent enEvent, tenFANPowerState enPwrState,
		   tU8 u8Speed, tU8 u8SpeedStart) = 0;
   virtual tBool bSetReqFanControl(tenFANID enFanID, tenFANCtrlModeEvent enEvent,
		   tenFANPowerState enPwrState, tU8 u8Speed, tU8 u8SpeedStart) = 0;
};

#endif /* I_HC_TCLFANCONTROL_H_ */
