/************************************************************************
* FILE:        hc_tclEmergencyFunction_Types.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base types of all emergency functions
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTION_TYPES_H_
#define HC_TCLEMERGENCYFUNCTION_TYPES_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclThermalSensor_Types.h"

/*******************************************************************************
| Emergency function enumerations and global function to get the name
|-----------------------------------------------------------------------------*/
enum tenEmergencyFunctionID
{
	enEmergencyFunctionID_UNDEF = 0,
	enEmergencyFunctionID_SystemShutdown,
	enEmergencyFunctionID_BacklightOFF,
	enEmergencyFunctionID_Attenuation,
	enEmergencyFunctionID_CDDriveOff,
	enEmergencyFunctionID_DVDDriveOff,
	enEmergencyFunctionID_TVModuleOff,
	enEmergencyFunctionID_MAX
};

const char* strGetEmergencyFunctionID(tenEmergencyFunctionID enFunctionID);
const char* strGetEmergencyFunctionAbbreviation(tenEmergencyFunctionID enFunctionID);

/*******************************************************************************
| Emergency function state enumerations and global function to get the name
|-----------------------------------------------------------------------------*/
enum tenEmergencyFunctionState
{
	enEmergencyFunctionState_DISABLED = 0,
	enEmergencyFunctionState_NoResult,
	enEmergencyFunctionState_Inactive,
	enEmergencyFunctionState_Active,
	enEmergencyFunctionState_ActiveHigh,
	enEmergencyFunctionState_ActiveLow,
	enEmergencyFunctionState_MAX
};

const char* strGetEmergencyFunctionState(tenEmergencyFunctionState enFunctionState);

/*******************************************************************************
| thermal sensor emergency function parameter
|-----------------------------------------------------------------------------*/
struct tEmergencyFunctionInfo_TS
{
	tenThermalState enUpperState : 8; // upper thermal state to activate emergency function
	tenThermalState enLowerState : 8; // lower thermal state to activate emergency function
	tenEmergencyFunctionState enFunctionState : 8; // current emergency function state
};

/*******************************************************************************
| Internal Emergency Function Information of specified thermal sensor
|-----------------------------------------------------------------------------*/
struct tEmergencyFunctionInfo_Internal
{
	tenThermalSensorID enSensorID;		// internal thermal sensor ID
	tenEmergencyFunctionState aenFunctionState[enEmergencyFunctionID_MAX];
	                                    // state of all emergency functions
};

/*******************************************************************************
| Internal Emergency Function State
|-----------------------------------------------------------------------------*/
struct tEmergencyFunctionState_Internal
{
	tenEmergencyFunctionID enFunctionID;		// emergency function ID
	tenEmergencyFunctionState enFunctionState;	// emergency functions state
};

#endif /* HC_TCLEMERGENCYFUNCTION_TYPES_H_ */
