/************************************************************************
* FILE:        hc_tclEmergencyFunctionSystemShutdown.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function SystemShutdown
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTIONSYSTEMSHUTDOWN_H_
#define HC_TCLEMERGENCYFUNCTIONSYSTEMSHUTDOWN_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclEmergencyFunction_Config.h"
#include "hc_tclEmergencyFunction.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

/*******************************************************************************
| Emergency function SystemShutdown configuration class definition
|-----------------------------------------------------------------------------*/
typedef hc_tclEmergencyFunction_ConfigTemplate<
		dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE, dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop,
		dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY, dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop>
hc_tclEmergencyFunctionSystemShutdown_Config;

/*******************************************************************************
| Emergency function SystemShutdown class definition
|-----------------------------------------------------------------------------*/
class hc_tclEmergencyFunctionSystemShutdown
: public hc_tclEmergencyFunction
, public hc_tclEmergencyFunctionSystemShutdown_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunctionSystemShutdown();
	virtual ~hc_tclEmergencyFunctionSystemShutdown();
};

#endif /* HC_TCLEMERGENCYFUNCTIONSYSTEMSHUTDOWN_H_ */
