/************************************************************************
* FILE:        hc_tclEmergencyFunctionAttenuation.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function Attenuation (volume reduction)
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTIONATTENUATION_H_
#define HC_TCLEMERGENCYFUNCTIONATTENUATION_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclEmergencyFunction_Config.h"
#include "hc_tclEmergencyFunction.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

/*******************************************************************************
| Emergency function Attenuation configuration class definition
|-----------------------------------------------------------------------------*/
typedef hc_tclEmergencyFunction_ConfigTemplate<
		dp_tclHeatCtrlDPATTENUATION_ENABLE, dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop,
		dp_tclHeatCtrlDPATTENUATION_DELAY, dp_tclHeatCtrlDPATTENUATION_DELAY_Develop>
hc_tclEmergencyFunctionAttenuation_Config;

/*******************************************************************************
| Emergency function SystemShutdown class definition
|-----------------------------------------------------------------------------*/
class hc_tclEmergencyFunctionAttenuation
: public hc_tclEmergencyFunction
, public hc_tclEmergencyFunctionAttenuation_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunctionAttenuation();
	virtual ~hc_tclEmergencyFunctionAttenuation();
};

#endif /* HC_TCLEMERGENCYFUNCTIONATTENUATION_H_ */
