/************************************************************************
* FILE:        hc_tclEmergencyFunctionAttenuation.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function Attenuation (volume reduction)
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "hc_tclEmergencyFunctionAttenuation.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclEmergencyFunctionAttenuation.cpp.trc.h"
#endif

/*******************************************************************************
*
* FUNCTION:    hc_tclEmergencyFunctionAttenuation()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunctionAttenuation::hc_tclEmergencyFunctionAttenuation()
: hc_tclEmergencyFunction(enEmergencyFunctionID_Attenuation)
, hc_tclEmergencyFunctionAttenuation_Config()
{
   ETG_TRACE_USR4(("hc_tclEmergencyFunctionAttenuation() entered."));
}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclEmergencyFunctionAttenuation()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunctionAttenuation::~hc_tclEmergencyFunctionAttenuation()
{
   ETG_TRACE_USR4(("~hc_tclEmergencyFunctionAttenuation() entered."));
}




