/************************************************************************
* FILE:        hc_tclEmergencyFunction.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of all emergency functions
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTION_H_
#define HC_TCLEMERGENCYFUNCTION_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclEmergencyFunction_Config.h"

/*******************************************************************************
| Emergency function class definition
|-----------------------------------------------------------------------------*/
class hc_tclEmergencyFunction
: virtual public hc_tclEmergencyFunction_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunction();
	hc_tclEmergencyFunction(tenEmergencyFunctionID enFunctionID);
	virtual ~hc_tclEmergencyFunction();

	inline tenEmergencyFunctionID enGetFunctionID(tVoid) const {return m_enFunctionID;};
	inline tenEmergencyFunctionState enGetFunctionState(tVoid) const {return m_enFunctionState;};

   virtual tVoid vTraceInfo();

   virtual tVoid vHandleMessage_NewEmergencyFunctionInfo(hc_tclBaseIf::TMsg &Msg, tBool &bStateChanged);
protected:
	inline tBool bSetFunctionState(tenEmergencyFunctionState enState)
	{
		if (enEmergencyFunctionState_MAX > enState)
			m_enFunctionState = enState;
		return (m_enFunctionState == enState);
	};
	inline tenEmergencyFunctionState enGetFunctionState(tenThermalSensorID enSensor) const
	{
		if (enThermalSensorID_MAX > enSensor)
			return m_aenFunctionState[enSensor];
		return enEmergencyFunctionState_DISABLED;
	};
	inline tBool bSetFunctionState(tenThermalSensorID enSensor, tenEmergencyFunctionState enState)
	{
		if ((enThermalSensorID_MAX > enSensor) && (enEmergencyFunctionState_MAX > enState))
		{
			m_aenFunctionState[enSensor] = enState;
			return TRUE;
		}
		return FALSE;
	};
	// state machine
	tVoid vEmergencyFunction_SM(const tEmergencyFunctionInfo_Internal &tEmergencyFunctionInfo, tBool &bStateChanged);
	// make EM_TRACE entry
	tVoid vMakeEMTRACEEmergencyFunction(tenThermalSensorID enSensorID, tU32 u32SensorMask) const;
	// trace status info
	virtual tVoid vTraceInfo_EF(const char* strIdentifier);
	// own function ID
	tenEmergencyFunctionID m_enFunctionID;
	// own general function state
	tenEmergencyFunctionState m_enFunctionState;
	// function states of all known thermal sensors
	tenEmergencyFunctionState m_aenFunctionState[enThermalSensorID_MAX];
};

#endif /* HC_TCLEMERGENCYFUNCTION_H_ */
