/************************************************************************
* FILE:        hc_tclClientTVMODULEtemp.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class definition of client handler TV module temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 16.08.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/
#ifndef APPL_TVMODULETEMP_HC_TCLCLIENTTVMODULETEMP_H_
#define APPL_TVMODULETEMP_HC_TCLCLIENTTVMODULETEMP_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#include "I_hc_tclClientTVMODULEtemp.h"
#include "hc_tclThermalSensor_Types.h"
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

class I_hc_tclThermalSensorControl;
class I_hc_tclSimuMode;

#define HC_CLIENTTVMODULETEMP_CLNAME                 "hc_tclClientTVMODULEtemp"
#define HC_CLIENTTVMODULETEMP_CYCLETIME_SECONDS                              30
#define HC_CLIENTTVMODULETEMP_DEFAULT_DEVICE                       "/dev/i2c-1"

enum tenTVModuleSensorID
{
	enTVModuleSensorID_TVModule = 0,
	enTVModuleSensorID_TVModuleSlave,
	enTVModuleSensorID_MAX,
	enTVModuleSensorID_UNDEF,
	enTVModuleSensorID_SUPPORTED
};

class hc_tclClientTVMODULEtemp : public I_hc_tclClientTVMODULEtemp
{
public:
	hc_tclClientTVMODULEtemp(tVoid);
	hc_tclClientTVMODULEtemp(const hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientTVMODULEtemp();

   virtual const tChar* getName() const { return HC_CLIENTTVMODULETEMP_CLNAME; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tBool bIsServiceAvailable() const;
   virtual tU32 u32GetPollingCycleTime(tVoid) const;
   virtual tVoid onGET_Temp(tenTVModuleSensorID enSensor, tS16 s16Temperature);
   virtual tVoid sendTemperatureGet();

   tenThermalSensorID enConvertSensorID(tenTVModuleSensorID) const;
   tenTVModuleSensorID enConvertSensorID(tenThermalSensorID) const;

   inline tBool bIsEnable(tVoid) const {return m_bEnable;};
   inline tBool bIsAvailable(tVoid) const {return (TRUE == bIsEnable()?m_bAavailable : FALSE);};
   inline const char* strGetDevice(tVoid) const {return (const char*)m_strDevice;};
   inline tU8 u8GetSlaveAddress(tVoid) const {return m_u8SlaveAddress;};
   inline tU8 u8GetRegisterAddress(tVoid) const {return m_u8RegisterAddress;};
protected:
   tVoid vHandleMessage_UpdateSimuMode(hc_tclBaseIf::TMsg &Msg);
   tVoid vHandleMessage_LoadSettings(hc_tclBaseIf::TMsg &Msg);
   tBool bFindInLookup(tS16 S16ADCvalue, tU16& u16IdxStart, tU16& u16IdxEnd) const;
   tS16 s16Convert2Temperature(tU16 u16ADCvalue) const;
   static OSAL_tpfCallback cb_vTimerReadTemp(tVoid* pArg);
   tBool bReadI2cRegister(const char* strDev, const tU8 u8SlaveAddress, const tU8 u8RegisterAddress, tU16& u16RegisterData);
   tBool bWriteI2cRegister(const char* strDev, const tU8 u8SlaveAddress, const tU8 u8RegisterAddress, tU8 u8RegisterData) const;
   tVoid vHandleMessage_TrcCmd_GetState(const tUChar* puchData);

   I_hc_tclSimuMode* m_poSimuMode;
   OSAL_tTimerHandle m_hTimerReadTemp;
   tenTVModuleSensorID m_aenOwnSensorID[enThermalSensorID_MAX];
   hc_tclBaseIf::TMsg m_aoThermalInfo[enTVModuleSensorID_MAX];
   hc_tclBaseIf::TMsg m_oTriggerReadTemp;
   char m_strDevice[256];
   tU8 m_u8SlaveAddress;
   tU8 m_u8RegisterAddress;
   tU16 m_u16PollInterval;
   tBool m_bEnable : 1;
   tBool m_bAavailable : 1;
};

#endif /* APPL_TVMODULETEMP_HC_TCLCLIENTTVMODULETEMP_H_ */
