/************************************************************************
* FILE:        hc_tclSimuMode.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: common simulation mode class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclSimuMode.h"
#include "hc_AppMain.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclSimuMode.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
*
* FUNCTION:    hc_tclSimuMode()
*
* DESCRIPTION: constructor
*
* PARAMETER:   const hc_tclAppMain*
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclSimuMode::hc_tclSimuMode(const hc_tclAppMain* poMainAppl)
: I_hc_tclSimuMode(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclSimuMode() entered."));
   // status of simulation mode
   m_bState = FALSE;
   // prepare simulation mode broadcast message
   (tVoid)memset((tVoid*)&m_msgSimuMode,OSAL_NULL,sizeof(m_msgSimuMode));
   m_msgSimuMode.eCmd = hc_tclBaseIf::eUpdateSimuMode;
}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclSimuMode()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclSimuMode::~hc_tclSimuMode()
{
   ETG_TRACE_USR4(("~hc_tclSimuMode() entered."));
}

/*************************************************************************
*
* FUNCTION:    vHandleMessage
*
* DESCRIPTION: handle internal message
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg : reference of received internal message
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclSimuMode::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
	   HC_NULL_POINTER_CHECK(pMsg);
	   ETG_TRACE_USR4(("vHandleMessage() entered %u -> data: %d.", ETG_ENUM(HC_INT_MSG , (tU32)pMsg->eCmd), pMsg->u.u32Data));
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTraceMessage()
*
* DESCRIPTION: 	handler for trace command
*
* PARAMETER:   	const tUChar* puchData: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclSimuMode::vHandleTraceMessage(const tUChar* puchData)
{
	ETG_TRACE_USR4(("vHandleTraceMessage() entered (data: 0x%08x).", puchData ));
	HC_NULL_POINTER_CHECK(puchData);

	tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
	switch (u32MsgCode) {
	case FC_HEATCTRL_HC_GETSIMUMODE:
	   {
		   vHandleTraceCmd_GetSimuMode(puchData);
	   }
	   break;

	case FC_HEATCTRL_HC_SETSIMUMODE:
	   {
		   vHandleTraceCmd_SetSimuMode(puchData);
	   }
	   break;

	default:
	   ETG_TRACE_USR4(("vHandleTraceMessage(): unhandled command %d.", u32MsgCode));
	   break;
	}
}

/*******************************************************************************
*
* FUNCTION: 	vGetReferences(tVoid)
*
* DESCRIPTION: 	Function to get all reference needed by this class.
* 				A reference should always be the Interface class of the object
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclSimuMode::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vGetReferences() entered."));
}

/*******************************************************************************
*
* FUNCTION: 	tVoid vStartCommunication()
*
* DESCRIPTION: 	Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclSimuMode::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vStartCommunication() entered."));
}

/*******************************************************************************
*
* FUNCTION: 	vTraceInfo()
*
* DESCRIPTION: 	Trace information
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclSimuMode::vTraceInfo()
{
	ETG_TRACE_USR4(("vTraceInfo() entered."));
}

/*******************************************************************************
*
* FUNCTION:    vSetSimuMode()
*
* DESCRIPTION: constructor
*
* PARAMETER:   tBool bActive
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclSimuMode::vSetSimuMode(tBool bActive)
{
   ETG_TRACE_USR4(("hc_tclSimuMode(active: %d) entered.", bActive));
   m_bState = bActive;
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTraceCmd_GetSimuMode()
*
* DESCRIPTION: 	handler for trace command HC_GetSimuMode
*
* PARAMETER:   	const tUChar* puchData: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclSimuMode::vHandleTraceCmd_GetSimuMode(const tUChar* puchData)
{
   ETG_TRACE_USR4(("vHandleTraceCmd_GetSimuMode() entered (data: 0x%08x).", puchData ));
   HC_NULL_POINTER_CHECK(puchData);

   ETG_TRACE_FATAL(("%26s: HC_GetSimuMode",
		   "HC.APPL.SIMU.CMD__.START" ));

   ETG_TRACE_USR2(("%026s: ", "HC.APPL.SIMU.MODE_.START" ));
   ETG_TRACE_USR2(("%26s: %30s=%u ",
		   "HC.APPL.SIMU.MODE_.ATTR_", "                MODE",
		   ETG_ENUM(HC_SimuMode, bGetSimuMode()) ));
   ETG_TRACE_USR2(("%026s: ", "HC.APPL.SIMU.MODE_.END__" ));

   ETG_TRACE_FATAL(("%26s: finished without errors",
		   "HC.APPL.SIMU.CMD__.RES__" ));
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTraceCmd_SetSimuMode()
*
* DESCRIPTION: 	handler for trace command HC_SetSimuMode
*
* PARAMETER:   	const tUChar* puchData: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclSimuMode::vHandleTraceCmd_SetSimuMode(const tUChar* puchData)
{
   ETG_TRACE_USR4(("vHandleTraceCmd_SetSimuMode() entered (data: 0x%08x).", puchData ));
   HC_NULL_POINTER_CHECK(puchData);

   tU8 param1 = puchData[3];

   ETG_TRACE_FATAL(("%26s: HC_SetSimuMode %u",
		   "HC.APPL.SIMU.CMD__.START",
		   ETG_ENUM(HC_SimuMode, param1) ));

   tBool _bSimuMode = bGetSimuMode();
   if (TRUE == param1)
	   vSetSimuMode(TRUE);
   else
	   vSetSimuMode(FALSE);
   ETG_TRACE_USR2(("%026s: ", "HC.APPL.SIMU.MODE_.START" ));
   ETG_TRACE_USR2(("%26s: %30s=%u ", "HC.APPL.SIMU.MODE_.ATTR_", "                MODE",
		   ETG_ENUM(HC_SimuMode, bGetSimuMode()) ));
   ETG_TRACE_USR2(("%026s: ", "HC.APPL.SIMU.MODE_.END__" ));
   // send broadcast message to all interfaces
   m_msgSimuMode.u.UpdateSimuMode.bState = bGetSimuMode();
   if (_bSimuMode != bGetSimuMode())
	   hc_tclAppMain::theServer()->vPostInternalMessage(&m_msgSimuMode);

   ETG_TRACE_FATAL(("%26s: finished without errors",
		   "HC.APPL.SIMU.CMD__.RES__" ));
}
