/************************************************************************
* FILE:        hc_tclCfgMgr_Types.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: common configuration manager types
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 24.06.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLCFGMGR_TYPES_H_
#define HC_TCLCFGMGR_TYPES_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

/*******************************************************************************
| enumeration of KDS sensor configurations
|-----------------------------------------------------------------------------*/
enum tenKDSDataSensor
{
	enKDSDataSensor_01 = 0,
	enKDSDataSensor_02,
	enKDSDataSensor_03,
	enKDSDataSensor_04,
	enKDSDataSensor_05,
	enKDSDataSensor_MAX
};

/*******************************************************************************
| enumeration of KDS sensor IDs
|-----------------------------------------------------------------------------*/
enum tenKDSDataSensorID
{
	enKDSDataSensorID_UNDEF = 0,
	enKDSDataSensorID_SCC,
	enKDSDataSensorID_Panel,
	enKDSDataSensorID_CDDrive,
	enKDSDataSensorID_DVDDrive,
	enKDSDataSensorID_GNSS,
	enKDSDataSensorID_Gyro,
	enKDSDataSensorID_eMMC,
	enKDSDataSensorID_Amplifier,
	enKDSDataSensorID_ApplicationProcessor,
	enKDSDataSensorID_HeatSink,
	enKDSDataSensorID_Blueray,
	enKDSDataSensorID_XMTuner,
	enKDSDataSensorID_TVModule,
	enKDSDataSensorID_TVModuleSlave,
	enKDSDataSensorID_Panel2,
	enKDSDataSensorID_MAX
};

/*******************************************************************************
| enumeration of KDS sensor threshold configurations
|-----------------------------------------------------------------------------*/
enum tenKDSDataSensorThreshold
{
	enKDSDataSensorThreshold_CriticalHigh = 0,
	enKDSDataSensorThreshold_High,
	enKDSDataSensorThreshold_Low,
	enKDSDataSensorThreshold_CriticalLow,
	enKDSDataSensorThreshold_MAX
};

#endif /* HC_TCLCFGMGR_TYPES_H_ */
