/************************************************************************
* FILE:        hc_tclCfgMgr.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: common configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 24.06.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLCFGMGR_H_
#define HC_TCLCFGMGR_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_hc_tclCfgMgr.h"
#include "hc_tclCfgMgr_PDDTHM.h"
#include "hc_tclThermalSensor_Types.h"

// datapool access
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_fc_heatctrl_if.h"

//******************************************************************************
// class for PDD data pool access
//******************************************************************************
typedef hc_tclCfgMgr_PDDTHMTemplate<
		dp_tclThmDpPDDPDD_THM_Version,
		hc_tclCfgMgr_PDDSensorConfigTemplate<
				dp_tclThmDpPDDPDD_THM_SensorID_1,
				dp_tclThmDpPDDPDD_THM_MaximumTemperature_1,
				dp_tclThmDpPDDPDD_THM_MinimumTemperature_1,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_HighTemperature_1,
						dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1,
						dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_LowTemperature_1,
						dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1,
						dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1> >,
		hc_tclCfgMgr_PDDSensorConfigTemplate<
				dp_tclThmDpPDDPDD_THM_SensorID_2,
				dp_tclThmDpPDDPDD_THM_MaximumTemperature_2,
				dp_tclThmDpPDDPDD_THM_MinimumTemperature_2,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_HighTemperature_2,
						dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2,
						dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_LowTemperature_2,
						dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2,
						dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2> >,
		hc_tclCfgMgr_PDDSensorConfigTemplate<
				dp_tclThmDpPDDPDD_THM_SensorID_3,
				dp_tclThmDpPDDPDD_THM_MaximumTemperature_3,
				dp_tclThmDpPDDPDD_THM_MinimumTemperature_3,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_HighTemperature_3,
						dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3,
						dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_LowTemperature_3,
						dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3,
						dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3> >,
		hc_tclCfgMgr_PDDSensorConfigTemplate<
				dp_tclThmDpPDDPDD_THM_SensorID_4,
				dp_tclThmDpPDDPDD_THM_MaximumTemperature_4,
				dp_tclThmDpPDDPDD_THM_MinimumTemperature_4,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_HighTemperature_4,
						dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4,
						dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_LowTemperature_4,
						dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4,
						dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4> >,
		hc_tclCfgMgr_PDDSensorConfigTemplate<
				dp_tclThmDpPDDPDD_THM_SensorID_5,
				dp_tclThmDpPDDPDD_THM_MaximumTemperature_5,
				dp_tclThmDpPDDPDD_THM_MinimumTemperature_5,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5,
						dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_HighTemperature_5,
						dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5,
						dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_LowTemperature_5,
						dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5,
						dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5>,
				hc_tclCfgMgr_PDDThresholdTemplate<
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5,
						dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5> >,
		dp_tclThmDpPDDPDD_THM_RESERVED
		> hc_tclCfgMgr_PDDTHM;
//******************************************************************************
// configuration manager class
//******************************************************************************
class hc_tclCfgMgr : public I_hc_tclCfgMgr
{
public:
    // constructors and destructors
	hc_tclCfgMgr(tVoid);
	hc_tclCfgMgr(const hc_tclAppMain* poMainAppl);
	virtual ~hc_tclCfgMgr();

   virtual const tChar* getName() const { return "hc_tclCfgMgr"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tU8 u8GetKDSSensorEnable(tenThermalSensorID enSensorID) const;
   virtual tS16 s16GetPDDSensorThreshold(tenThermalSensorID enSensorID, tenKDSDataSensorThreshold enThreshold, tBool bHysteresisRequired) const;
   virtual tS16 s16GetPDDSensorMaxTemp(tenThermalSensorID enSensorID) const;
   virtual tS16 s16GetPDDSensorMinTemp(tenThermalSensorID enSensorID) const;
   virtual tU8 u8GetKDSFANEnable(tVoid) const;

   virtual tVoid vOnLoadSettings(tVoid);
protected:
   tVoid vLoadHWConfig(tVoid);
   tVoid vMirrorPDDTHM(tVoid);
   tVoid vTraceInfo_HWConfig(const char* strIdentifier) const;
   tVoid vTraceInfo_PDDTHM(const char* strIdentifier) const;
   inline tenKDSDataSensor enGetSensorIdx(tenThermalSensorID enSensorID) const {
	   if (enThermalSensorID_MAX > enSensorID && (tenThermalSensorID)0 <= enSensorID)
		   return m_aenSensorIdx[enSensorID];
	   return enKDSDataSensor_MAX;
   }
   inline tBool bSetSensorIdx(tenThermalSensorID enSensorID, tenKDSDataSensor enSensorIdx) {
	   if ((enThermalSensorID_UNDEF < enSensorID) && (enThermalSensorID_MAX > enSensorID) && (enKDSDataSensor_MAX > enSensorIdx))
		   m_aenSensorIdx[enSensorID] = enSensorIdx;
	   return (enGetSensorIdx(enSensorID) == enSensorIdx);
   }
   tenKDSDataSensor m_aenSensorIdx[enThermalSensorID_MAX];
   hc_tclCfgMgr_PDDTHM m_oPDDTHM;
   tU8 m_au8KDSSensorEnable[enThermalSensorID_MAX];
   tU8 m_u8KDSFANEnable;
};

#endif /* HC_TCLCFGMGR_H_ */
