/************************************************************************
* FILE:        I_hc_tclCfgMgr.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: interface common configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 24.06.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_HC_TCLCFGMGR_H_
#define I_HC_TCLCFGMGR_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclCfgMgr_Types.h"

class I_hc_tclCfgMgr : public hc_tclBaseIf
{
public:
	// constructor
	I_hc_tclCfgMgr(tVoid);
	I_hc_tclCfgMgr(const hc_tclAppMain* poMainAppl) : hc_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_hc_tclCfgMgr(){};

   virtual const tChar* getIfName() const { return "I_hc_tclCfgMgr"; };

   virtual tU8 u8GetKDSSensorEnable(tenThermalSensorID enSensorID) const = 0;
   virtual tS16 s16GetPDDSensorThreshold(tenThermalSensorID enSensorID, tenKDSDataSensorThreshold enThreshold, tBool bHysteresisRequired) const = 0;
   virtual tS16 s16GetPDDSensorMaxTemp(tenThermalSensorID enSensorID) const = 0;
   virtual tS16 s16GetPDDSensorMinTemp(tenThermalSensorID enSensorID) const = 0;
   virtual tU8 u8GetKDSFANEnable(tVoid) const = 0;

   virtual tVoid vOnLoadSettings(tVoid) = 0;
};



#endif /* I_HC_TCLCFGMGR_H_ */
