/**
 * @file   : cfgmgr_INAClientHandler.h
 * @author : nce5kor
 * @date   : Aug 24, 2017
 * @brief  : Interface file for Application client handler, with pure virtual functions
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_INACLIENTHANDLER_H_
#define CFGMGR_INACLIENTHANDLER_H_

#include "boost/shared_ptr.hpp"
#include <de/bosch/cm/ConfigManager/ConfigData.h>
#include <de/bosch/cm/ConfigManager/ConfigDataProxy.h>
#include <de/bosch/cm/ConfigManager/ConfigManagement.h>

#ifndef CFGMGR_TYPES_H
#include "../asf/cfgmgr_Types.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
using namespace ::asf::core;
using namespace de::bosch::cm::ConfigManager::ConfigData;
using namespace de::bosch::cm::ConfigManager::ConfigManagement;

#include <iostream>

using namespace std;

class cfgmgr_INAClientHandler
{

public:
	cfgmgr_INAClientHandler() {}
	~cfgmgr_INAClientHandler() {}

	virtual tVoid updatePrivateData(DescmoState_T configItem, ConfigItem_T data, ::boost::shared_ptr<ConfigDataProxy > proxy) = 0;

	virtual tVoid updatePublicData(tStr itemName, ConfigItem_T data, ::boost::shared_ptr<ConfigDataProxy > proxy) = 0;

	virtual tVoid SendXMLData(DescmoState_T configItem, ::boost::shared_ptr<ConfigDataProxy > proxy) = 0;

	virtual tVoid getPrivateData(DescmoState_T configItem, ::boost::shared_ptr<ConfigDataProxy > proxy) = 0;

	virtual ::boost::shared_ptr<ConfigDataProxy > createProxy(tStr Dbus_Name) = 0;
};

#endif // CFGMGR_INACLIENTHANDLER_H_
