/**
 * @file   : cfgmgr_UpdateManager.h
 * @author : nce5kor
 * @date   : Aug 24, 2017
 * @brief  : Central class for Data/ localdata / registration / setSystemToDelivery request-response
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef cfgmgr_UpdateManager_H_
#define cfgmgr_UpdateManager_H_

#ifndef CFGMGR_INACLIENTHANDLER_H_
#include "../interfaces/cfgmgr_INAClientHandler.h"
#endif

#ifndef CFGMGR_IRESPONSE_LISTENER_H_
#include "../interfaces/cfgmgr_IResponseListener.h"
#endif

#ifndef CFGMGR_IUPDATEMANAGER_H_
#include "../interfaces/cfgmgr_IUpdateManager.h"
#endif
#ifndef CFGMGR_DLTWRAPPER_H_
#include "../trace/cfgmgr_DltWrapper.h"
#endif

#ifndef CFGMGR_DATAPOOLHANDLER_H_
#include "cfgmgr_DatapoolHandler.h"
#endif

DLT_IMPORT_CONTEXT (CFM0)
DLT_IMPORT_CONTEXT (CMIT)
using namespace cfmg;

class cfgmgr_UpdateManager: public cfgmgr_IUpdateManager
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_UpdateManager);
public:

	//--------------------------------------------------------------------------
	// Handling of Registrations Requests from Components
	//--------------------------------------------------------------------------

	virtual Reg_Status_T registerPrivateConfigItem(ClientData_T& clientData);

	virtual Reg_Status_T unregisterPrivateConfigItem(tStr itemName, tStr dbusName);

	virtual Reg_Status_T registerPublicConfigItem(ClientData_T& clientData);

	virtual Reg_Status_T unregisterPublicConfigItem(tStr itemName, tStr dbusName);

	//--------------------------------------------------------------------------
	// Handling of Data Requests from FOTA
	//--------------------------------------------------------------------------

	//Send Private and Public Data from FOTA
	virtual tVoid SendData(map<tStr,tStr> configData, DescmoState_T configItem, tbool isCfgMgrRegistered, tStr actionType );

    //Send XML Data
	virtual tVoid SendDataXml(DescmoState_T configItem);

	//--------------------------------------------------------------------------
	// Handling of Response received from Apps
	//--------------------------------------------------------------------------

	tVoid onSetPrivateItem(Cfgmgr_ItemStatus_T result, DescmoState_T configItem, tStr actionType);

	tVoid onGetPrivateItem(Cfgmgr_ItemStatus_T result, ConfigItem_T data, DescmoState_T configItem, tStr actionType);

	tVoid onExchangeDESCMO(Cfgmgr_ItemStatus_T result, tStr xmlData, DescmoState_T configItem);

	//--------------------------------------------------------------------------
	// Handling of Data Requests from Components
	//--------------------------------------------------------------------------

    //Send the Public/Local Data from HMI
	virtual Cfgmgr_ItemStatus_T SendDataPublic(map<tStr,tStr> configData, tStr configItemName);

    //Get the Public/Local Data
	virtual Cfgmgr_ItemStatus_T getPublicData(tStr configItemName, ConfigItem_T& itemList); // To get the public data from datapool

	//--------------------------------------------------------------------------
	// Other Local Methods
	//--------------------------------------------------------------------------

	static cfgmgr_UpdateManager* getInstanceofUpdateManager();

	tVoid registerClientHandler(cfgmgr_INAClientHandler* pHandler);

	virtual tVoid setListener(cfgmgr_IResponseListener *pListener);

	virtual tVoid unsetListener();

	//Get the Client details from Proxy database
	virtual bool checkForConfigItemSubscribed(tStr profileName, FormatIdentifier &formatId,tbool &isCfgMgrRegistered);

	~cfgmgr_UpdateManager();

	tVoid SetDefaultPrivateData(ConfigItem_T configDataList,DescmoState_T configItem);
	tVoid GetDefaultPrivateData(ConfigItem_T configDataList, DescmoState_T configItem);

	tVoid SetDefaultPublicData(ConfigItem_T configDataList,DescmoState_T configItem);
	tVoid GetDefaultPublicData(ConfigItem_T configDataList,DescmoState_T configItem);

	tStr printResult(Cfgmgr_ItemStatus_T result);

	tVoid updateClientPublicItem(UpdateType updateType, tStr itemName, tStr dbusName);

	Cfgmgr_ItemStatus_T setDpData(ConfigItem_T& configDataList, tStr configItemName);
	Cfgmgr_ItemStatus_T getDpData(ConfigItem_T& configDataList, tStr configItemName);
	tVoid sendUpdate(ConfigItem_T& configDataList,tStr profileName);

protected:
	cfgmgr_UpdateManager();
private:

	static cfgmgr_UpdateManager *m_pUpdateManager;

	cfgmgr_INAClientHandler *m_pInterface;

	cfgmgr_IResponseListener *m_pListener;

	cfgmgr_DatapoolHandler *m_pDatapoolHandler;

	tVoid addDataToList(map<tStr,tStr> data,  ConfigItem_T& itemList);

	ConfigItem_T mConfigItem;

};

#endif

