/**
 * @file   : cfgmgr_RegistrationRequestHandler.cpp
 * @author : nce5kor
 * @date   : Aug 18, 2017
 * @brief  : To handle data for registration requests from applications
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef cfgmgr_RegistartionRequestHandler_H_
#include "cfgmgr_RegistrationRequestHandler.h"
#endif

DLT_IMPORT_CONTEXT (CFM0)
DLT_IMPORT_CONTEXT (CMIT)

cfgmgr_RegistrationRequestHandler* cfgmgr_RegistrationRequestHandler::pRequestHandler = NULL;

/***********************************************************************************************/
/* 				Method to get the instance of Registration Request handler					   */
/***********************************************************************************************/
cfgmgr_RegistrationRequestHandler* cfgmgr_RegistrationRequestHandler::getInstanceofRegistrationRequestHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_RegistrationRequestHandler::getInstanceofRegistrationRequestHandler()");

	if (pRequestHandler == NULL)
	{
		pRequestHandler = new cfgmgr_RegistrationRequestHandler();
	}
	return pRequestHandler;
}

/***********************************************************************************************/
/* 				Method to get the instance of Update Manager								   */
/***********************************************************************************************/
#ifndef __UNITTEST_CFGMGR__
cfgmgr_UpdateManager* cfgmgr_RegistrationRequestHandler::getInstanceOfUpdateManager()
{
	return cfgmgr_UpdateManager::getInstanceofUpdateManager();
}
#endif

/***********************************************************************************************/
/* 				cfgmgr_RegistrationRequestHandler Constructor								   */
/***********************************************************************************************/
cfgmgr_RegistrationRequestHandler::cfgmgr_RegistrationRequestHandler():m_pUpdateManager(NULL)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_RegistrationRequestHandler::cfgmgr_RegistrationRequestHandler() Constructor");

#ifndef __UNITTEST_CFGMGR__
    m_pUpdateManager = getInstanceOfUpdateManager();
#endif
}

/***********************************************************************************************/
/* 				cfgmgr_RegistrationRequestHandler Destructor								   */
/***********************************************************************************************/
cfgmgr_RegistrationRequestHandler::~cfgmgr_RegistrationRequestHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_RegistrationRequestHandler::cfgmgr_RegistrationRequestHandler() Destructor");

	if(NULL != m_pUpdateManager)
	{
		m_pUpdateManager = NULL;
	}
	if(NULL != pRequestHandler)
	{
		delete pRequestHandler;
		pRequestHandler = NULL;
	}
}

/***********************************************************************************************/
/* 							Method to handle registration requests							   */
/***********************************************************************************************/
Reg_Status_T cfgmgr_RegistrationRequestHandler::registerConfigItem(ClientData_T& clientData)
{
	Reg_Status_T result = REG_STATUS_FAILED;

	log(&CFM0,DLT_LOG_INFO,"cfgmgr_RegistrationRequestHandler::registerConfigITem");

	if(NULL != m_pUpdateManager)
	{
		switch(clientData.itemType)
		{
		case PRIVATE_LIST:
			result = m_pUpdateManager->registerPrivateConfigItem(clientData);
			break;
		case PUBLIC_LIST:
			result = m_pUpdateManager->registerPublicConfigItem(clientData);
			break;
		default:
			break;
		}
	}
	else
	{
		log(&CFM0,DLT_LOG_ERROR,"cfgmgr_RegistrationRequestHandler::registerConfigItem -- m_pUpdateManager Pointer is NULL");
	}
	return result;
}

/***********************************************************************************************/
/* 							Method to handle Unregistration requests						   */
/***********************************************************************************************/
Reg_Status_T cfgmgr_RegistrationRequestHandler::unregisterConfigItem(ClientData_T clientData)
{
	Reg_Status_T result = REG_STATUS_FAILED;

	log(&CFM0,DLT_LOG_INFO,"cfgmgr_RegistrationRequestHandler::unregisterConfigItem");

	if(NULL != m_pUpdateManager)
	{
		switch(clientData.itemType)
		{
		case PRIVATE_LIST:
			result = m_pUpdateManager->unregisterPrivateConfigItem(clientData.itemName, clientData.dbusName);
			break;
		case PUBLIC_LIST:
			result = m_pUpdateManager->unregisterPublicConfigItem(clientData.itemName, clientData.dbusName);
			break;
		default:
			break;
		}
	}
	else
	{
		log(&CFM0,DLT_LOG_ERROR,"cfgmgr_RegistrationRequestHandler::unregisterConfigItem -- m_pUpdateManager Pointer is NULL");
	}
	return result;
}
