/**
 * @file   : cfgmgr_LocalDataHandler
 * @author : nce5kor
 * @date   : Aug 18, 2017
 * @brief  : To handle data for local item set/get from applications
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef CFGMGR_LOCALDATAHANDLER_H_
#include "cfgmgr_LocalDataHandler.h"
#endif

DLT_IMPORT_CONTEXT (CFM0)
DLT_IMPORT_CONTEXT (CMIT)

cfgmgr_LocalDataHandler* cfgmgr_LocalDataHandler::pLocalDataHandler = NULL;

/***********************************************************************************************/
/* 				Method to get the instance of Registration Request handler					   */
/***********************************************************************************************/
cfgmgr_LocalDataHandler* cfgmgr_LocalDataHandler::getInstanceofLocalDataHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_RegistrationRequestHandler::getInstanceofLocalDataHandler()");

	if (NULL == pLocalDataHandler)
	{
		pLocalDataHandler = new cfgmgr_LocalDataHandler();
	}
	return pLocalDataHandler;
}

/***********************************************************************************************/
/* 				Method to get the instance of Update Manager								   */
/***********************************************************************************************/
#ifndef __UNITTEST_CFGMGR__
cfgmgr_UpdateManager* cfgmgr_LocalDataHandler::getInstanceOfUpdateManager()
{
	return cfgmgr_UpdateManager::getInstanceofUpdateManager();
}
#endif
/***********************************************************************************************/
/* 				cfgmgr_RegistrationRequestHandler Constructor								   */
/***********************************************************************************************/
cfgmgr_LocalDataHandler::cfgmgr_LocalDataHandler():m_pUpdateManager(NULL)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_LocalDataHandler::cfgmgr_LocalDataHandler() Constructor");

#ifndef __UNITTEST_CFGMGR__
    m_pUpdateManager = getInstanceOfUpdateManager();
#endif
}

/***********************************************************************************************/
/* 				cfgmgr_RegistrationRequestHandler Destructor								   */
/***********************************************************************************************/
cfgmgr_LocalDataHandler::~cfgmgr_LocalDataHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_RegistrationRequestHandler::cfgmgr_RegistrationRequestHandler() Destructor");

	if(NULL != m_pUpdateManager)
	{
		m_pUpdateManager = NULL;
	}

	if(NULL != pLocalDataHandler)
	{
		delete pLocalDataHandler;
		pLocalDataHandler = NULL;
	}
}

/************************************************************************************************************/
/* 				Method to set the public Data in datapool and also to update the apps    	                */
/************************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_LocalDataHandler::SendDataPublic(map<tStr,tStr> configData, tStr configItemName)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_LocalDataHandler::SendDataPublic");

	if(NULL != m_pUpdateManager)
	{
		return (m_pUpdateManager->SendDataPublic(configData,configItemName));
	}
	else
	{
		return STATUS_FAILED;
	}
}

/************************************************************************************************************/
/* 				Method to get the public Data from datapool and also to update the apps    	                */
/************************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_LocalDataHandler::getPublicData(tStr configItemName, ConfigItem_T& itemList)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_LocalDataHandler::getPublicData");

	if(NULL != m_pUpdateManager)
	{
		return (m_pUpdateManager->getPublicData(configItemName,itemList));
	}
	else
	{
		return STATUS_FAILED;
	}
}
