/**
 * @file   : cfgmgr_DefaultSettingHandler.cpp
 * @author : hld5kor
 * @date   : Aug 24, 2017
 * @brief  : Handler to manage system set to delivery
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_DEFAULT_SETTING_HANDLER_H_
#include "cfgmgr_DefaultSettingHandler.h"
#endif

/********************************************************************************************/
/*				            Method to get instance of Update Manager   						*/
/********************************************************************************************/
cfgmgr_UpdateManager* cfgmgr_DefaultSettingHandler::getInstanceOfUpdateManager()
{
	return cfgmgr_UpdateManager::getInstanceofUpdateManager();
}

/********************************************************************************************/
/*				            cfgmgr_DefaultSettingHandler Constructor  						*/
/********************************************************************************************/
cfgmgr_DefaultSettingHandler::cfgmgr_DefaultSettingHandler():m_pInterface(NULL)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DefaultSettingHandler::cfgmgr_DefaultSettingHandler()");
	m_pInterface = getInstanceOfUpdateManager();
}

/********************************************************************************************/
/*				            cfgmgr_DefaultSettingHandler Destructor  						*/
/********************************************************************************************/
cfgmgr_DefaultSettingHandler::~cfgmgr_DefaultSettingHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DefaultSettingHandler::~cfgmgr_DefaultSettingHandler()");
	if (NULL != m_pInterface)
	{
		m_pInterface = NULL;
	}
}

/***********************************************************************************************/
/* Reset all datapool values to default, during system set to delivery function is called		*/
/***********************************************************************************************/
tVoid cfgmgr_DefaultSettingHandler::tResetPublicData(tVoid)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DefaultSettingHandler::tResetPublicData");

	m_pInterface->updateClientPublicItem(CFGMGR_UPDATE_ON_SSTDS,"","");
	// This Function is not implmented as of now since there are no running functionalities to stop. May be this will be used in future.
}
