/**
 * @file   : cfgmgr_DatapoolHandler.h
 * @author : bma9kor
 * @date   : Aug 21, 2017
 * @brief  : Manage insert and delete of datapool values
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : ConfigManager
 * @{
 */

#ifndef CFGMGR_DATAPOOLHANDLER_H_
#define CFGMGR_DATAPOOLHANDLER_H_

#ifndef CFGMGR_DATAPOOL_PUBLICITEM_H_
#include "cfgmgr_Datapool_PublicItem.h"
#endif

using namespace std;
using namespace cfmg;

class cfgmgr_DatapoolHandler{

	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_DatapoolHandler);
	cfgmgr_IDatapoolHandler* mpInstance;

public:
    cfgmgr_DatapoolHandler();
	virtual ~cfgmgr_DatapoolHandler(void);

	Cfgmgr_ItemStatus_T setDatapool(tStr configKey, tStr configValue,DatapoolType type);
	Cfgmgr_ItemStatus_T getDatapool(tStr ConfigName,vector<ConfigData_T>& publicItem,DatapoolType type);

	tVoid getInstance(tVoid);
	tVoid deleteInstance();

#ifdef __UNITTEST_CFGMGR__
	void reg_cfgmgr_IDatapool(cfgmgr_IDatapoolHandler* um_IPtr)
	{
		mpInstance = um_IPtr;
	}
#endif
};


#endif /* ifndef CFGMGR_DATAPOOLHANDLER_H_ */
