/*
 * cfgmgr_DatapoolHandler.cpp
 *
 *  Created on: Aug 21, 2017
 *      Author: bma9kor
 */
#ifndef CFGMGR_DATAPOOLHANDLER_H_
#include "cfgmgr_DatapoolHandler.h"
#endif

DLT_IMPORT_CONTEXT (CFM0)
DLT_IMPORT_CONTEXT (CMIT)

/********************************************************************************/
/* 						cfgmgr_DatapoolHandler Constructor			            */
/********************************************************************************/
cfgmgr_DatapoolHandler::cfgmgr_DatapoolHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DatapoolHandler::cfgmgr_DatapoolHandler Constructor ");
	mpInstance = NULL;
}

/********************************************************************************/
/* 						cfgmgr_DatapoolHandler Destructor			            */
/********************************************************************************/
cfgmgr_DatapoolHandler::~cfgmgr_DatapoolHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DatapoolHandler::cfgmgr_DatapoolHandler Destructor ");
}

/*********************************************************************************/
/* 						cfgmgr_DatapoolHandler SetDatapool		                 */
/*********************************************************************************/
 Cfgmgr_ItemStatus_T cfgmgr_DatapoolHandler::setDatapool(tStr configKey, tStr configValue,DatapoolType type)
 {
	 log(&CFM0,DLT_LOG_INFO,"cfgmgr_DatapoolHandler::setDatapool");
	 Cfgmgr_ItemStatus_T status = STATUS_FAILED;

#ifndef __UNITTEST_CFGMGR__
	 getInstance();
#endif

	 if(mpInstance != NULL)
	 {
		 switch(type)
		 {
			 case DP_CSA:
			 {
				 status = mpInstance->vSetCSA(configKey,configValue);
				 break;
			 }
			 case DP_URL:
			 {
				 status = mpInstance->vSetURL(configKey,configValue);
				 break;
			 }
			 case DP_PARTID:
			 {
				 status = mpInstance->vSetPARTID(configKey,configValue);
				 break;
			 }
			 default:
			 {
				 log(&CFM0,DLT_LOG_ERROR,"DP TYPE NOT FOUND");
				 status = STATUS_UNKNOWN_ITEM;
				 break;
			 }
		 }
	 }
	 else
	 {
		 log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DatapoolHandler::setDatapool - mpInstance is NULL ");
	 }

#ifndef __UNITTEST_CFGMGR__
	 deleteInstance();
#endif

	 return status;
 }

 /***********************************************************************************************************/

 /***********************************************************************************************************/
 Cfgmgr_ItemStatus_T cfgmgr_DatapoolHandler::getDatapool(tStr ConfigName,vector<ConfigData_T>& publicItem,DatapoolType type)
 {
	 log(&CFM0,DLT_LOG_INFO,"cfgmgr_DatapoolHandler::getDatapool");
	 ConfigData_T data;
	 Cfgmgr_ItemStatus_T status = STATUS_FAILED;

#ifndef __UNITTEST_CFGMGR__
	 getInstance();
#endif

	 if(mpInstance != NULL)
	 {
		 switch(type)
		 {
			 case DP_CSA:
			 {
				 status = mpInstance->vGetCSA(publicItem,data);
				 break;
			 }
			 case DP_URL:
			 {
				 status = mpInstance->vGetURL(publicItem,data);
				 break;
			 }
			 case DP_PARTID:
			 {
				 status = mpInstance->vGetPARTID(publicItem,data);
				 break;
			 }
			 default:
			 {
				 log(&CFM0,DLT_LOG_ERROR,"DP TYPE NOT FOUND");
				 status = STATUS_UNKNOWN_ITEM;
				 break;
			 }
		 }
	 }
	 else
	 {
		 log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DatapoolHandler::getDatapool - mpInstance is NULL ");
	 }

#ifndef __UNITTEST_CFGMGR__
	 deleteInstance();
#endif

	 return status;
 }


/****************************************************************************************************/
#ifndef __UNITTEST_CFGMGR__
 tVoid cfgmgr_DatapoolHandler::getInstance(tVoid)
 {
	 log(&CFM0,DLT_LOG_INFO,"cfgmgr_DatapoolHandler::getInstance");

	 if(!mpInstance)
	 {
		 mpInstance = new cfgmgr_Datapool_PublicItem;
	 }

	 return;
 }
#endif
 /****************************************************************************************/

 tVoid cfgmgr_DatapoolHandler::deleteInstance()
 {
	 if(mpInstance != NULL)
	 {
		 delete mpInstance;
		 mpInstance = NULL;
	 }
 }

 /*****************************************************************************************/
