/**
 * @file   : cfgmgr_DataRequestHandler.h
 * @author : mrr8kor
 * @date   : Aug 18, 2017
 * @brief  : To handle Data from Ota client to update handler
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef cfgmgr_DataRequestHandler_H_
#define cfgmgr_DataRequestHandler_H_

#ifdef __OTA_COMPONENT_ENABLE__
#ifndef CFGMGR_DESCMOHANDLER_H_
#include "../framework/cfgmgr_DESCMOHandler.h"
#endif
#else
#ifndef CFGMGR_TYPES_H
#include "../asf/cfgmgr_Types.h"
#endif
#endif

#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#endif

#include "dp_if.h"
#include "dp_generic_if.h"

// Include DESCMO Library header file

#ifndef CFGMGR_CLIENTDATABASE_H_
#include "cfgmgr_ClientDatabase.h"
#endif

#ifndef CFGMGR_INTERFACE_OTACLIENT_LISTENER
#include "../interfaces/cfgmgr_IOtaClientListener.h"
#endif

#ifndef CFGMGR_IRESPONSE_LISTENER_H_
#include "../interfaces/cfgmgr_IResponseListener.h"
#endif

#ifndef cfgmgr_UpdateManager_H_
#include "../framework/cfgmgr_UpdateManager.h"
#endif

class cfgmgr_DataRequestHandler: public cfgmgr_IResponseListener
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_DataRequestHandler);

	public:
	cfgmgr_DataRequestHandler();
	virtual ~cfgmgr_DataRequestHandler();

	tVoid processRequest(DescmoState_T descmoData);
	tVoid sendResponseToOTAComponent(const tUInt32 ECUId,const tUInt32 CorrelatorId,const tUInt32 ErrorCode, tCStr xmlData);

	//--------------------------------------------------------------------------
	// Methods inherited from cfgmgr_IResponseListener
	//--------------------------------------------------------------------------

	void onDefaultDataResponse(vector<ConfigData_T> configData, Cfgmgr_ItemStatus_T status, DescmoState_T& configItem, tStr actionType);
	void onXmlDataResponse(tStr xmlData,Cfgmgr_ItemStatus_T status, DescmoState_T& configItem);

	cfgmgr_descmoResult clientResponseStatusMapping(Cfgmgr_ItemStatus_T status);

	//--------------------------------------------------------------------------
	// Other Local Methods
	//--------------------------------------------------------------------------

	tVoid ReadVIN();

	static cfgmgr_DataRequestHandler* getInstanceofDataRequestHandler();

	tVoid registerClientHandler(cfgmgr_IOtaClientListener* pListener);

	tVoid addDelimiter(map<tStr,tStr> configData,tStr methodName,map<tStr,tStr> &finalMapData);
	tVoid removeDelimiter(vector<ConfigData_T> configData,map<tStr,tStr> &finalMapData);

	private:

	tStr m_VIN;

	static cfgmgr_DataRequestHandler* pRequestHandler;
	cfgmgr_IOtaClientListener *m_pOtaListener;
	cfgmgr_UpdateManager* m_pInterface;

#ifdef __OTA_COMPONENT_ENABLE__
	cfgmgr_IDataHandler* mpDataPtr;
#endif

	cfgmgr_UpdateManager* getInstanceOfUpdateManager();
};

#endif /* cfgmgr_DataRequestHandler_H_ */
