/*
 * cfgmgr_DESCMOParser.h
 *
 *  Created on: Nov 14, 2017
 *      Author: ogm5kor
 */

#ifndef CFGMGR_DESCMOPARSER_H_
#define CFGMGR_DESCMOPARSER_H_

#include <iostream>
#include <cstring>
#include <fstream>
#include "tinyxml/tinyxml.h"

#ifndef CFGMGR_DLTWRAPPER_H_
#include "../trace/cfgmgr_DltWrapper.h"
#endif

using namespace cfmg;

class cfgmgr_DESCMOParser {
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_DESCMOParser);
public:
	cfgmgr_DESCMOParser();
	virtual ~cfgmgr_DESCMOParser();

	static cfgmgr_DESCMOParser* getInstanceofDESCMOParser();

	tbool parseParameters(tStr &_xmlSignature, tStr &_profileName);
	tbool getAttribute(tStr &outString, const TiXmlElement* base, const char* value);
	tbool parseXml(tStr xmlFile,tStr &_xmlData, tStr &_xmlSignature, tStr &_profileName);

	tVoid extractCustomSetting(tStr &_xmlData, tStr &line);
	tbool extractProfileName(tStr &_profileName, TiXmlElement* elem);
	tbool extractXmlSignature(tStr &_xmlSignature, TiXmlElement* elem);

	TiXmlElement* getRootNode() const
    {
		return _rootNode;
    }

private:
	static cfgmgr_DESCMOParser* pDESCMOParser;

	tStr _xml;
	TiXmlDocument _xmlDoc;
	TiXmlElement* _rootNode;
	tbool customPresent;
};

#endif /* CFGMGR_DESCMOPARSER_H_ */
