/**
 * @file   : cfgmgr_types.h
 * @author : bma9kor
 * @date   : Aug 24, 2017
 * @brief  : typesefs for types used in cfgmgr
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_TYPES_H_
#define CFGMGR_TYPES_H_

#include <iostream>
#include <string>
#include <cstring>
#include <map>
#include <vector>
#include <algorithm>
#include <fstream>
#include <sstream>
#include <sys/stat.h>

using namespace std;

#define CFGMGR_ECU_ID    			201
#define CFGMGR_ECU_NAME 			"RDO"
#define CFGMGR_VIN_DATA_LENGTH 		17
#define CFGMGR_MAX_STRING_LENGTH    255

#define CFGMGR_ZERO                 0
#define CFGMGR_ONE                  1
#define CFGMGR_TIMEOUT_VAL          59950 // This can be discussed in next team meeting
#define CFGMGR_DATAPOOL_SIZE		1   // This needs to be updated if any public data items are added.
#define CFGMGR_ITEM_NOT_FOUND		-1
#define CFGMGR_SECURE_DATAPOOL_SIZE		2

#define CFGMGR_PUBLIC_ITEM_TABLE_SIZE (CFGMGR_DATAPOOL_SIZE + CFGMGR_SECURE_DATAPOOL_SIZE)

#define DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(class)                                         \
protected:                                                                                         \
   /**
    * \brief deprecated copy constructor
    */                                                                                             \
    class ( const class& obj );                                                                    \
                                                                                                   \
    /**
     * \brief deprecated assignment operator
     */                                                                                            \
    class& operator = ( const class& obj )


typedef bool                    tbool;
typedef void                    tVoid;

typedef char                    tChar;
typedef unsigned char           tUChar;
typedef signed char			    tSChar8;

typedef unsigned char           tUInt8;

typedef unsigned short          tUInt16;
typedef short                   tSInt16;

typedef unsigned int            tUInt32;
typedef int                     tSInt32;

typedef string 					tStr;
typedef const string            tCStr;

typedef unsigned short          tUShort;
typedef short                   tShort;

typedef unsigned long           tULong64;
typedef long int                tSLong64;

typedef float                   tFloat;
typedef double                  tDouble;
typedef long double             tLDouble;

typedef char*                   tString;
typedef const char*             tCString;

typedef char*                   tPChar;
typedef const char*             tCPChar;
typedef void*                   tPVoid;


typedef struct configData {
	tStr key;
	tStr value;
}ConfigData_T;

typedef std::vector< ConfigData_T > ConfigItem_T;


typedef struct customSetData {
	tStr Name;
	tStr MethodName;
	tStr ActionType;
	tStr ECUName;
}stCustomSetData;

typedef enum {
	DEFAULT_FORMAT,
	XML_FORMAT
}FormatIdentifier;


typedef enum {
	PRIVATE_LIST,
	PUBLIC_LIST
}ListType;

typedef enum {
	DP_CSA,
	DP_URL,
	DP_PARTID,
	DP_UNKNOWN
}DatapoolType;

typedef enum {
	CFGMGR_UPDATE_ON_REG,
	CFGMGR_UPDATE_ON_SSTDS,
	CFGMGR_UPDATE_ON_SET
}UpdateType;

typedef struct descmoState
{
   tUInt32 ecuId;
   tUInt32 correlatorId;
   tStr xmlData;
   tStr xmlDataSignature;
   tStr profileName;
}DescmoState_T;


/*typedef struct clientData*/
struct ClientData_T
{
	// error in copyconstructor; last element
//	ClientData_T ( const ClientData_T& obj ) : itemName(obj.itemName),dbusName(obj.dbusName),formatId(obj.formatId),itemType(PUBLIC_LIST){ }
	tStr itemName;
	tStr dbusName;
	FormatIdentifier formatId;
	ListType itemType;
}/*ClientData_T*/;

enum cfgmgr_descmoResult {
        SUCCESS = 1200,
        CANCELLED = 1401,
        TIMEOUT = 1450,
        PARTIAL = 1452,
        FAILED = 1460,
        INVALID = 1461,
        NOT_SUPPORTED = 1462,
        ECU_NOT_EXIST = 1463,
        SETTINGS_EXECUTION_TIMEOUT = 1464,
        ADDITIONAL_DATA_VALIDATION_FAILED = 1465,
        SETTINGS_PROFILE_SIGNATURE_INVALID = 1466,
        SETTINGS_SIGNATURE_INVALID = 1467
};

typedef enum cfgmrg_results {
	CFGMGR_SUCEESS,
	CFGMGR_FAILED
}Cfgmgr_Result_T;

typedef enum itemStatus {
	STATUS_SUCCESS = 0,
	STATUS_FAILED,
	STATUS_UNKNOWN_ITEM,
	STATUS_NO_PERMISSION,
	STATUS_INAVLID_VALUE,
	STATUS_INVALID_SIGNATURE
}Cfgmgr_ItemStatus_T;

typedef enum registerStatus {
	REG_STATUS_SUCCESS = 0,
	REG_STATUS_FAILED,
	REG_STATUS_UNKNOWN_ITEM,
	REG_STATUS_ALREADY_REGISTERED,
	REG_STATUS_ALREADY_UNREGISTERED
}Reg_Status_T;


template<typename T> tStr trim(T str)
{
	size_t first = str.find_first_not_of(' ');
	size_t last = str.find_last_not_of(' ');

	if ((string::npos == first) && (string::npos == last))
	{
		str.erase(0, str.length());
		return (str);
	}
	else
	{
		return str.substr(first, (1 + last - first));
	}
}

inline bool is_digits(const std::string &str)
{
    return str.find_first_not_of("0123456789") == std::string::npos;
}

inline bool is_alpha(const std::string &str)
{
    string alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    return str.find_first_not_of(alpha) == std::string::npos;
}

template<typename T,typename T1> tbool CompareStrings(T str1,T1 str2)
{
	//return (trim(str1) == trim(str2));
	return (str1 == str2);
}

template<typename T,typename T1> size_t findCaseInsensitive(T str1,T1 str2, size_t pos = CFGMGR_ZERO)
{
	//transform(str1.begin(), str1.end(), str1.begin(), ::tolower);  // STR to lowercase
	//transform(str2.begin(), str2.end(), str2.begin(), ::tolower);  // SUBSTR to lowercase

	return str1.find(str2,pos);
}

#endif
