/**
 * @file   : cfgmgr_DiagnosisClient.cpp
 * @author : mrr8kor
 * @date   : Aug 24, 2017
 * @brief  : To handle systemsettings with Diagnosis component
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_DIAGNOSIS_CLIENT_H_
#include "cfgmgr_DiagnosisClient.h"
#endif

namespace asf{

using namespace org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

/********************************************************************************/
/* 			Method called from DIAG to prepare for the factory reset            */
/********************************************************************************/
tVoid cfgmgr_DiagnosisClient::onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DiagnosisClient::onPrepareSystemSettingRequest");

	::std::string sysSetID = request->getSysSetID();
	::std::string sysSetType = request->getSysSetType();
	tUInt32 cookie = request->getCookie();

	::std::vector< PrepareSystemSettingResponseExtendedDataStruct > extendedData;

	sendPrepareSystemSettingResponse(sysSetID, sysSetType, extendedData, CFGMGR_SUCEESS, cookie);
}

/********************************************************************************/
/* 			Method called from DIAG to Execute for the factory reset            */
/********************************************************************************/
tVoid cfgmgr_DiagnosisClient::onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DiagnosisClient::onExecuteSystemSettingRequest");

	::std::string sysSetID = request->getSysSetID();
	::std::string sysSetType = request->getSysSetType();
	tUInt32 cookie = request->getCookie();

	::std::vector< ExecuteSystemSettingResponseExtendedDataStruct > extendedData;
	sendExecuteSystemSettingResponse(sysSetID, sysSetType, extendedData, CFGMGR_SUCEESS, cookie);
}

/********************************************************************************/
/* 			Method called from DIAG to Finalize for the factory reset           */
/********************************************************************************/
tVoid cfgmgr_DiagnosisClient::onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DiagnosisClient::onFinalizeSystemSettingRequest");

	::std::string sysSetID = request->getSysSetID();
	::std::string sysSetType = request->getSysSetType();
	tUInt32 cookie = request->getCookie();

	::std::vector< FinalizeSystemSettingResponseExtendedDataStruct > extendedData;

	/* This code is commented as per the request from customer. Task reference: AIVI-66911 */
	//_SysSettingPtr->tResetPublicData();

	sendFinalizeSystemSettingResponse(sysSetID, sysSetType, extendedData, CFGMGR_SUCEESS, cookie);
}

}
