/**
 * @file   : cfgmgr_Communication.cpp
 * @author : mrr8kor
 * @date   : Aug 24, 2017
 * @brief  : Handle ASF communication
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef CFGMGR_COMMUNICATION_H_
#include "cfgmgr_Communication.h"
#endif

#ifndef CFGMGR_ASF_OTA_CLIENT_H_
#include "cfgmgr_ASFOtaClient.h"
#endif

using namespace asf;

DLT_DECLARE_CONTEXT(CFM0)
DLT_DECLARE_CONTEXT(CMIT) //For Testing

#define STAT_ERROR -1

/*Initialization of static self-referential object*/
cfgmgr_Communication* cfgmgr_Communication::m_poCMCommunicationObj=NULL;

/********************************************************************************/
/* 						cfgmgr_Communication constructor  			            */
/********************************************************************************/
cfgmgr_Communication::cfgmgr_Communication()
{

}

/********************************************************************************/
/* 						cfgmgr_Communication destructor  			            */
/********************************************************************************/
cfgmgr_Communication::~cfgmgr_Communication ( tVoid )
{
	if(NULL != m_poCMCommunicationObj)
	{
		delete m_poCMCommunicationObj;
		m_poCMCommunicationObj = NULL;
	}

	cfgmgr_DltWrapper::instance(true)->unregisterContext(CFM0);
	cfgmgr_DltWrapper::instance(true)->unregisterContext(CMIT);
}

/********************************************************************************/
/* 			Method called on Startup for Trace Class initialization             */
/********************************************************************************/
tbool cfgmgr_Communication::bOnInit()
{
	//Register for DLT
	cfgmgr_DltWrapper::instance(true)->registerApp(DLT_APPID_FC_CFMG,"CFMG(Config Manager) Registration for Logging");
	cfgmgr_DltWrapper::instance(true)->registerContext(CFM0,"CFM0", "CFMG(Config Manager) Context for Logging",DLT_LOG_DEBUG,DLT_TRACE_STATUS_DEFAULT);
	cfgmgr_DltWrapper::instance(true)->registerContext(CMIT,"CMIT", "DLT Test Logging",DLT_LOG_DEBUG,DLT_TRACE_STATUS_DEFAULT);
	dlt_register_injection_callback(&CMIT, 0x1000, CFGMGR_TEST_SET_PRIVATE_DATA);
	dlt_register_injection_callback(&CMIT, 0x1001, CFGMGR_TEST_GET_PRIVATE_DATA);
	dlt_register_injection_callback(&CMIT, 0x1002, CFGMGR_TEST_SET_PUBLIC_DATA);
	dlt_register_injection_callback(&CMIT, 0x1003, CFGMGR_TEST_GET_PUBLIC_DATA);
	dlt_register_injection_callback(&CMIT, 0x1004, CFGMGR_TEST_SEND_DATA_XML);
	dlt_register_injection_callback(&CMIT, 0x1005, CFGMGR_PrintPrivateRegistrationTable);
	dlt_register_injection_callback(&CMIT, 0x1006, CFGMGR_PrintPublicRegistrationTable);
	dlt_register_injection_callback(&CMIT, 0x1007, CFGMGR_TEST_SET_MAP_UPDATE_REGION_SETID);

	return true;
}

/********************************************************************************/

std::vector<tStr> cfgmgr_Communication::getStringList(std::string &str,tChar delimiter,tUInt32 size)
{
	tStr temp;
	std::vector<tStr> strList;

	for(tUInt32 i = 0 ; i < size; i++)
	{
		temp.clear();
		std::string::size_type pos = str.find(delimiter);
		if (pos != std::string::npos)
		{
			temp=str.substr(0,pos);
			str.erase(0,1+pos);
		}
		else
		{
			temp = str;
			str.erase(0,str.length());
		}

		strList.push_back(temp);
	}

	return strList;
}

/********************************************************************************/

std::vector<ConfigData_T> cfgmgr_Communication::getKeyValuePairList(tStr str)
{

	tStr temp = str;
	std::vector<ConfigData_T> myVector;
	ConfigData_T strctData;

	tUInt32 size = std::count(temp.begin(), temp.end(), '|');

	std::vector<string> myList = getStringList(temp,'|',1+size);

	for(tUInt32 i = 0; i < myList.size(); i++)
	{
		size = std::count(myList[i].begin(), myList[i].end(), ':');
		std::vector<tStr> myPairs = getStringList(myList[i],':',1+size);

		if(2 != myPairs.size())
		{
			myVector.clear();
			break;
		}
		else
		{
			strctData.key = myPairs[0];
			strctData.value = myPairs[1];
			myVector.push_back(strctData);
		}
	}

	return myVector;
}

/********************************************************************************/

tSInt32 cfgmgr_Communication::CFGMGR_TEST_SET_PRIVATE_DATA(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_TEST_SET_PRIVATE_DATA Test Started ************");

	if (0 < length)
	{
		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr tBuff = DataBuffer;
		DescmoState_T configItem = {CFGMGR_ECU_ID,CFGMGR_ONE,"","",""};
		std::vector< ConfigData_T > ConfigItem;
		ConfigItem.clear();

		tUInt32 size = std::count(tBuff.begin(), tBuff.end(), ';');

		std::vector<tStr> myList = m_poCMCommunicationObj->getStringList(tBuff,';',1+size);

		if(2 != myList.size())
		{
			log(&CMIT,DLT_LOG_ERROR,"NO OF PARAMETERS INVALID");
		}
		else
		{
			if(myList[0].empty())
			{
				log(&CMIT,DLT_LOG_ERROR,"CONFIG_ITEMNAME EMPTY");
			}
			else if(myList[1].empty())
			{
				log(&CMIT,DLT_LOG_ERROR,"KEY-VALUE PAIR EMPTY");
			}
			else
			{
				configItem.profileName = myList[0];
				ConfigItem = m_poCMCommunicationObj->getKeyValuePairList(myList[1]);

				if(0 != ConfigItem.size())
				{
					(cfgmgr_UpdateManager::getInstanceofUpdateManager())->SetDefaultPrivateData(ConfigItem,configItem);
				}
				else
				{
					log(&CMIT,DLT_LOG_ERROR,"INVALID KEY-VALUE PAIR");
				}
			}
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}

/********************************************************************************/

tSInt32 cfgmgr_Communication::CFGMGR_TEST_GET_PRIVATE_DATA(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_TEST_GET_PRIVATE_DATA Test Started ************");

	if (0 < length)
	{
		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr tBuff = DataBuffer;
		DescmoState_T configItem  = {CFGMGR_ECU_ID,CFGMGR_ONE,"","",""};
		std::vector< ConfigData_T > ConfigItem;
		ConfigItem.clear();

		tUInt32 size = std::count(tBuff.begin(), tBuff.end(), ';');

		std::vector<tStr> myList = m_poCMCommunicationObj->getStringList(tBuff,';',1+size);

		if(1 != myList.size())
		{
			log(&CMIT,DLT_LOG_ERROR,"NO OF PARAMETERS INVALID");
		}
		else
		{
			if(myList[0].empty())
			{
				log(&CMIT,DLT_LOG_ERROR,"CONFIG_ITEMNAME EMPTY");
			}
			else
			{
				configItem.profileName = myList[0];
				(cfgmgr_UpdateManager::getInstanceofUpdateManager())->GetDefaultPrivateData(ConfigItem,configItem);
			}
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}

/********************************************************************************/

tSInt32 cfgmgr_Communication::CFGMGR_TEST_SET_PUBLIC_DATA(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_TEST_SET_PUBLIC_DATA Test Started ************");

	if (0 < length)
	{
		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr tBuff = DataBuffer;
		tStr profileName;
		std::vector< ConfigData_T > ConfigItem;
		Cfgmgr_ItemStatus_T itemStatus = STATUS_FAILED;
		ConfigItem.clear();

		tUInt32 size = std::count(tBuff.begin(), tBuff.end(), ';');

		std::vector<tStr> myList = m_poCMCommunicationObj->getStringList(tBuff,';',1+size);

		if(2 != myList.size())
		{
			log(&CMIT,DLT_LOG_ERROR,"NO OF PARAMETERS INVALID");
			return 0;
		}

		if(myList[0].empty())
		{
			log(&CMIT,DLT_LOG_ERROR,"CONFIG_ITEMNAME EMPTY");
		}
		else if(myList[1].empty())
		{
			log(&CMIT,DLT_LOG_ERROR,"KEY-VALUE PAIR EMPTY");
		}
		else
		{
			profileName = myList[0];
			ConfigItem = m_poCMCommunicationObj->getKeyValuePairList(myList[1]);

			if(0 != ConfigItem.size())
			{
				itemStatus =(cfgmgr_UpdateManager::getInstanceofUpdateManager())->setDpData(ConfigItem,profileName);
				if(itemStatus == STATUS_SUCCESS)
				{
					(cfgmgr_UpdateManager::getInstanceofUpdateManager())->updateClientPublicItem(CFGMGR_UPDATE_ON_SET,profileName,"");
				}
			}
			else
			{
				log(&CMIT,DLT_LOG_ERROR,"INVALID KEY-VALUE PAIR");
			}
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}

/********************************************************************************/

tSInt32 cfgmgr_Communication::CFGMGR_TEST_GET_PUBLIC_DATA(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_TEST_GET_PUBLIC_DATA Test Started ************");

	if (0 < length)
	{
		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr tBuff = DataBuffer;
        tStr profileName;
		std::vector< ConfigData_T > ConfigItem;
		ConfigItem.clear();

		tUInt32 size = std::count(tBuff.begin(), tBuff.end(), ';');

		std::vector<tStr> myList = m_poCMCommunicationObj->getStringList(tBuff,';',1+size);

		if(1 != myList.size())
		{
			log(&CMIT,DLT_LOG_ERROR,"NO OF PARAMETERS INVALID");
		}
		else
		{
			if(myList[0].empty())
			{
				log(&CMIT,DLT_LOG_ERROR,"CONFIG_ITEMNAME EMPTY");
			}
			else
			{
				profileName = myList[0];
				(cfgmgr_UpdateManager::getInstanceofUpdateManager())->getDpData(ConfigItem,profileName);
			}
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}

/********************************************************************************/

tSInt32 cfgmgr_Communication::CFGMGR_TEST_SEND_DATA_XML(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_TEST_SEND_DATA_XML Test Started ************");

	if (0 < length)
	{
		struct stat st;

		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr filename = DataBuffer;

		if(stat(filename.c_str(), &st) == STAT_ERROR)
		{
			log(&CMIT,DLT_LOG_ERROR,"File do not exists");
			return 0;
		}
		else
		{
			DescmoState_T configItem;
			configItem.correlatorId = CFGMGR_ONE;
			configItem.ecuId = CFGMGR_ECU_ID;

			cfgmgr_DESCMOParser::getInstanceofDESCMOParser()->parseXml(filename,configItem.xmlData,configItem.xmlDataSignature,configItem.profileName);

			log(&CMIT,DLT_LOG_INFO,"cfgmgr_Communication::CFGMGR_TEST_SEND_DATA_XML ::: xmlData -- ",configItem.xmlData);
			log(&CMIT,DLT_LOG_INFO,"cfgmgr_Communication::CFGMGR_TEST_SEND_DATA_XML ::: xmlDataSignature -- ",configItem.xmlDataSignature);
			log(&CMIT,DLT_LOG_INFO,"cfgmgr_Communication::CFGMGR_TEST_SEND_DATA_XML ::: profileName -- ",configItem.profileName);

			cfgmgr_DataRequestHandler::getInstanceofDataRequestHandler()->processRequest(configItem);
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}

/********************************************************************************/

tSInt32 cfgmgr_Communication::CFGMGR_PrintPrivateRegistrationTable(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_PrintPrivateRegistrationTable Test Started ************");

	if (0 < length)
	{
		struct stat st;

		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr itemtype = "PRIVATE";
		cfgmgr_ClientDatabase *pCMApp = cfgmgr_ClientDatabase::createProxyDatabaseObject();

		if(pCMApp != NULL)
		{
			pCMApp->getConfigItemList(itemtype);
		}
		else
		{
			log(&CMIT,DLT_LOG_ERROR,"pCMApp pointer is NULL");
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}

/********************************************************************************/

tSInt32 cfgmgr_Communication::CFGMGR_PrintPublicRegistrationTable(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_PrintPublicRegistrationTable Test Started ************");

	if (0 < length)
	{
		struct stat st;
		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr itemtype = "PUBLIC";
		cfgmgr_ClientDatabase *pCMApp = cfgmgr_ClientDatabase::createProxyDatabaseObject();

		if(pCMApp != NULL)
		{
			pCMApp->getConfigItemList(itemtype);
		}
		else
		{
			log(&CMIT,DLT_LOG_ERROR,"pCMApp pointer is NULL");
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}

tSInt32 cfgmgr_Communication::CFGMGR_TEST_SET_MAP_UPDATE_REGION_SETID(tUInt32 service_id, tVoid *data, tUInt32 length)
{
	log(&CMIT,DLT_LOG_INFO,"********** CFGMGR_TEST_SET_MAP_UPDATE_REGION_SETID Test Started ************");

	if (0 < length)
	{
		tChar *DataBuffer = static_cast<tChar*>(data);

		tStr tBuff = DataBuffer;
		DescmoState_T configItem = {CFGMGR_ECU_ID,CFGMGR_ONE,"","",""};
		std::vector< ConfigData_T > ConfigItem;
		ConfigData_T sData;
		ConfigItem.clear();

		configItem.profileName = "Map.updateRegionSetId";
		sData.key = "Id";
		sData.value = tBuff;

		ConfigItem.push_back(sData);

		if(0 != ConfigItem.size())
		{
			(cfgmgr_UpdateManager::getInstanceofUpdateManager())->SetDefaultPrivateData(ConfigItem,configItem);
		}
	}
	else
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH INCORRECT. PLEASE PROVIDE PROPER DATA");
	}

	return 0;
}
