/**
 * @file   : cfgmgr_ASFAppServer.h
 * @author : bma9kor
 * @date   : Aug 24, 2017
 * @brief  : The services listed in cfgmgr_ConfigManagement.fidl file are implemented in these files.
 *			 It allows other applications (clients) to un-/register for properties and set/get of public config items, handled by config manager.
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef CFGMGR_ASF_APPSERVER_H_
#define CFGMGR_ASF_APPSERVER_H_

#include <iostream>
#include "asf/core/BaseComponent.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusProxy.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigManagement.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementStub.h"

#ifndef CFGMGR_CLIENTDATABASE_H_
#include "../framework/cfgmgr_ClientDatabase.h"
#endif

#ifndef CFGMGR_UPDATEHANDLER_H_
#include "../framework/cfgmgr_UpdateManager.h"
#endif

#ifndef cfgmgr_RegistartionRequestHandler_H_
#include "../framework/cfgmgr_RegistrationRequestHandler.h"
#endif

#ifndef CFGMGR_LOCALDATAHANDLER_H_
#include "../framework/cfgmgr_LocalDataHandler.h"
#endif
using namespace ::asf::core;
using namespace cfmg;

namespace asf{

using namespace de::bosch::cm::ConfigManager::ConfigManagement;

class cfgmgr_ASFAppServer: public BaseComponent,
					       public ConfigManagementStub
{
public:
	//! default class constructor called only by ComponentFactory<dia_ASFComponentSensorLocation>::getComponent()
	cfgmgr_ASFAppServer();

	virtual ~cfgmgr_ASFAppServer();

	virtual tVoid onRegisterPrivateItemRequest (const ::boost::shared_ptr< RegisterPrivateItemRequest >& request);

	virtual tVoid onUnregisterPrivateItemRequest (const ::boost::shared_ptr< UnregisterPrivateItemRequest >& request);

	virtual tVoid onRegisterPublicItemRequest (const ::boost::shared_ptr< RegisterPublicItemRequest >& request);

	virtual tVoid onUnregisterPublicItemRequest (const ::boost::shared_ptr< UnregisterPublicItemRequest >& request);

	virtual tVoid onSetPublicItemRequest (const ::boost::shared_ptr< SetPublicItemRequest >& request);

	virtual tVoid onGetPublicItemRequest (const ::boost::shared_ptr< GetPublicItemRequest >& request);
	
   private:
	cfgmgr_RegistrationRequestHandler* m_pRequestHandler;
	cfgmgr_LocalDataHandler* mp_LocalDataPtr;

	cfgmgr_RegistrationRequestHandler* getInstanceofRegistrationRequestHandler();

};
}

#endif /* CFGMGR_ASF_APPSERVER_H_ */
