/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : AVRoutingParsingError.cpp
 * COMPONENT Name      : AVRoutingParsingError
 * @details         :
 * AUTHOR              : Sunil Sagar
 * Date                : 08.03.2020
 * Revision History    : 0.1
 * Date 03.08.2020     : Initial version
 */

#include "AVRoutingParsingError.h"
#include "plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AVROUTING_PARSER
#include "trcGenProj/Header/AVRoutingParsingError.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN


/*! ***********************************************************************
 *FUNCTION: 		tclAvRoutingParsingError
 *@details: 		Constr
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Sunil Sagar		Initial
 ************************************************************************/
tclAvRoutingParsingError::tclAvRoutingParsingError():m_u8ErrorCode(0){
	// TODO Auto-generated constructor stub
	ETG_TRACE_USR4(("tclAvRoutingParsingError: Constructor"));

}

/*! ***********************************************************************
 *FUNCTION: 		tclAvRoutingParsingError
 *@details: 		Destr
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Sunil Sagar		Initial
 ************************************************************************/
tclAvRoutingParsingError::~tclAvRoutingParsingError() {
	// TODO Auto-generated destructor stub
	ETG_TRACE_USR4(("tclAvRoutingParsingError: Destructor"));
}


/*! ***********************************************************************
 *FUNCTION: 		u8GetErrorCode
 *@details: 		Get the error code
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		tU8
 *@details
 *HISTORY:
 *08.03.2020		0.1		Sunil Sagar		Initial
 ************************************************************************/
tU8 tclAvRoutingParsingError::u8GetErrorCode(){
	return m_u8ErrorCode;
}

/*! ***********************************************************************
 *FUNCTION: 		vSetErrorCode
 *@details: 		Set the error code
 *REQUIREMENT ID:	NA
 *@param:		tU8
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Sunil Sagar		Initial
 ************************************************************************/
tVoid tclAvRoutingParsingError::vSetErrorCode(tU8 u8ErrorCode){
	m_u8ErrorCode = u8ErrorCode;
}

/*! ***********************************************************************
 *FUNCTION: 		vSetErrorDescription
 *@details: 		Set the error code
 *REQUIREMENT ID:	NA
 *@param:		string
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Sunil Sagar		Initial
 ************************************************************************/
tVoid tclAvRoutingParsingError::vSetErrorDescription(std::string sErrorDesc){
	m_sErrorDesc = sErrorDesc;
}

/*! ***********************************************************************
 *FUNCTION: 		sGetErrorDescription
 *@details: 		Set the error description
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		string
 *@details
 *HISTORY:
 *08.03.2020		0.1		Sunil Sagar		Initial
 ************************************************************************/
std::string tclAvRoutingParsingError::sGetErrorDescription() {
	return m_sErrorDesc;
}
