/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : tclEntityInfo.h
 * COMPONENT Name      : AVRoutingParser
 * DESCRIPTION         :
 * AUTHOR              : Sunil Sagar
 * Date                : 27.04.2020
 * Revision History    : 1.0
 * Date 27.04.2020     : Initial version
 * Date 28.05.2020     : Reviewed version
*/
 
//****************************************************************************/

/******************************************
API Description:-
INPUT STRING			Device Name
CMA 				- Amplifier
CMP 				- CamPort
CMG 				- MediaGlass
*******************************************/
#ifndef AVDECC_APPL_PLUGINS_ENT_INFO_H_
#define AVDECC_APPL_PLUGINS_ENT_INFO_H_
#include <string>
#include <vector>
#include <map>
#include "system_types.h"


typedef std::map<std::string, std::string> tSettingNameValueMap; //Setting of Media Glass
typedef std::vector<std::pair<std::string, std::string> >tCabinChannelMap; //Cabin output channel Map
typedef std::multimap<std::string, std::string> tEntityNameIPMap; //Mapping of entityName and IP
typedef std::vector<tU64> tEntityIdVector; //Vector of entity id
typedef std::vector<std::string> tEntityIPVector; //Vector of entity ip
typedef std::vector<std::string> tEntityMacVector; //Vector of MAC Id 
typedef std::map<std::string, std::string> tSinkLinkCabinMap; //Setting of Media Glass
typedef struct {
		tU64 u64EntityID;
		std::string sIP;
		uint16_t pos;
		std::string name;
		std::string srcNam;
		std::string type;
		std::string mode;
		std::string camclass;
		std::string view;       //required for split
		std::string source_1;   //required for split
		std::string source_2;   //required for split
		uint16_t camtextid; 
		}tCamPortInfo;
typedef struct {
		uint16_t pos;
		std::string srcNam;
		uint16_t camtextid; 
		}tCamData;
typedef std::vector<tCamData> tVecCamData;
typedef std::vector<tCamPortInfo> vecCamPortInfo;
typedef struct {
		uint16_t pos;
		std::string name;
		std::string view;
		std::string source_1;
		std::string source_2;
		std::string srcNam;
		uint16_t camtextid; 
		}tCamPortSplitInfo;
typedef std::vector<tCamPortSplitInfo> vecCamPortSplitInfo;
typedef struct {
		uint16_t pos;
		std::string name;
		uint16_t avdeccValue; 
		}tCamPortAvdeccSplitInfo;
typedef std::vector<tCamPortAvdeccSplitInfo> vecCamPortAvdeccSplitValue;
typedef struct {
		uint16_t pos;
		std::string srcNam;
		uint16_t camtextid; 
		}tSplitCamData;
typedef std::vector<tSplitCamData> tVecSplitCamData;

class tclEntityInfo{
	public:
		//API for starting parsing
		virtual tBool bParseXml() = 0;
		// Helpful for plugins to get EntityID of device 
		virtual tEntityIdVector vectorGetEntityID(tCString pDevName ) = 0;
		// Helpful for LCM to get EntityIp of device
		virtual tEntityIPVector vectorGetEntityIP(tCString pDevName ) = 0;
		//Currently no usecase but for future use
		virtual tEntityMacVector vectorGetEntityMac(tCString pDevName ) = 0;
		// To check entity Id exist
		virtual tBool bIsEntityIdExist(const tU64 u64EntityId ) = 0;
		// To check IP exist
		virtual tBool bIsIpExist(tCString pEntityIp) = 0;
		//Setting Info for Media Glass 
		virtual tSettingNameValueMap mapGetMediaGlassSetting(const tU64 u64EntityId) = 0;
		//Get all the device list
		virtual tEntityNameIPMap mapGetCompleteDeviceList() = 0;
		//Get mapping of cabin and device location
		virtual tSinkLinkCabinMap mapGetSinkCabinLinkList() = 0;
		//Get mapping of CabinChannel Details
	    virtual tCabinChannelMap getCabinChannelMap() = 0;
		//Get Error code 
		virtual tU8 u8GetErrorCode() = 0;
		//Get Error Description 
		virtual std::string sGetErrorDescription() = 0;
		//Get Entity Sink Link Name for Cabin Info  
		virtual std::string sGetEntitySinkLinkName(const tU64 u64EntityId) = 0;
		//Get Entity IP with given entity Id
		virtual std::string sGetEntityIP(const tU64 u64EntityId) = 0;
		//Print device list
		virtual tVoid vPrintDeviceList() = 0;
		//Get Entity Name with given entity Id
		virtual std::string sGetEntityName(const tU64 u64EntityId) = 0;
		//Get all the camera attribute values
		virtual tVecCamData vecGetCamSrc() = 0;
		//Get camera position based on entityid
		virtual uint16_t u16GetCamPos(tU64 u64EntityId) = 0;
		//Get camera position based on IP
		virtual uint16_t u16GetCamPos(std::string strIP) = 0;
		//To check if position tag si available
		virtual tBool bIsPosTagAvailable() = 0;
		
		virtual ~tclEntityInfo(){}
};
#endif /* AVDECC_APPL_PLUGINS_ENT_INFO_H_ */
