/************************************************************************
*FILE: 			 TTFisCmdHandler.cpp
*SW-COMPONENT:  HMI
*DESCRIPTION: 	 Defines the class TTFisCmdHandler which
*               handles TTFis input commands (that simulates Clients and Avdecc Plugin Components actions)
*AUTHOR:        Supriya Seshadri(RBEI/ECG5)
*COPYRIGHT:     (c) 2018 - 2019 Robert Bosch Car Multimedia GmbH
*HISTORY:
*16.06.2020 Rev. 0.1 Supriya Seshadri
* 		    Initial Revision.
************************************************************************/

#ifndef PLUGINTTFISCMD
#define PLUGINTTFISCMD

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/* Macros to be defined for including the needed trace files */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON

/*****************************************************************
| includes
|----------------------------------------------------------------*/

/* Header files required for Tracing out log statements */
#include "etrace_if.h"

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/*****************************************************************
| class declaration (scope: global)
|----------------------------------------------------------------*/

class TTFisCmdHandler; // Forward declaration

/*****************************************************************
		| typedefs (scope: global)
		|----------------------------------------------------------------*/
class TTFisCmdHandler
{
public:
	TTFisCmdHandler();
	~TTFisCmdHandler();

	static void initialize();

private:

	/* Assingment Operater, will not be implemented.
		So if an attempt for the assignment is made compiler complains.
		Copy constructor will also not be implemented */
	TTFisCmdHandler& operator= (
	const TTFisCmdHandler &corfoCmdHandler
	);
	TTFisCmdHandler(
	const TTFisCmdHandler &corfoCmdHandler
	);

};


#endif

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
