/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : clPluginDataProvider.h
* COMPONENT Name      : master_control_plugin
* DESCRIPTION         : Handles miscellaneous requests/updates to/from AVB devices such as below
*                     : 1) Enable/Disable map-out streaming on mediaGlass
* AUTHOR              : Preethi Alagappan
* Date                : 04.02.2019
* Revision History    : 0.1
* Date 10.09.2018     : Initial version
****************************************************************************/

/*****************************************************************
 | includes
 |----------------------------------------------------------------*/

#ifndef CL_PLUGINDATAPROVIDER_H
#define CL_PLUGINDATAPROVIDER_H

// The below include files are needed for AC_CLIENT_PLUGIN_ENTRY()
#include <cstdint>
#include <iostream>
#include <iomanip>
#include <chrono>
#include "clCommunicationProtocol.h"
#include "ACClientInterface.h"
#include "util.h"
#include "enumeration.h"

#include "boost/shared_ptr.hpp"
#include <mutex>              // std::mutex, std::unique_lock
#include <condition_variable> // std::condition_variable
#include <thread>
#include <vector>
#include <map>
#include "clPluginBase.h"
#include "AVRoutingParser.h"

//struct stEntityIDMap;
class clEndStationThread;
class clPluginQueueThread;
class clCommunicationProtocol;

class clPluginDataProvider
{
public:

    ~clPluginDataProvider();

    static clPluginDataProvider* getInstance();
    static void notification_callback(void * user_obj, int32_t notification_type, uint64_t entity_id, uint16_t cmd_type,
                                      uint16_t desc_type, uint16_t desc_index, uint32_t cmd_status,
                                      ACNotificationId * notification_id);
    static void acmp_notification_callback(void* user_obj, int32_t notification_type, uint16_t cmd_type,
                                         uint64_t talker_entity_id, uint16_t talker_unique_id,
                                         uint64_t listener_entity_id, uint16_t listener_unique_id,
                                         uint32_t cmd_status, ACNotificationId* notification_id);
	bool getEndStationDetails(std::string EntityName, stEntityDesc &stEntityDetails);
        bool getEndStationDetails(std::string strEntityName, vector<stEntityDesc> &stEntityDetails);
	void setEndStationDetails(stEntityDesc &tEntityDetails);
	void clearEndStationDetails();
    void registerPlugin();
    int registerGenCB();
    int registerACMPCB();

    static clPluginDataProvider* poSelf;
	void vNotifyESReadComplete();
	vector<stEntityDesc> vecGetEndStationVector();
	bool isEntityDisconnected();
	std::vector<stCamDesc> vecGetCamDesc();
	std::vector<uint64_t> vecGetReadComplete();
	void eraseVecReadComplete(uint64_t u64EntityID);

private:
    clPluginDataProvider();
	clPluginDataProvider(const clPluginDataProvider&);
	clPluginDataProvider& operator =(const clPluginDataProvider&);
    ACClientInterface *clientIf;
	static vector<stEntityDesc> m_vecEndStations;
	vector<clPluginBase *> m_PluginHelpers;
    static clCommunicationProtocol *m_pCommControl;
	static clEndStationThread *m_pEndStationThread;
	static clPluginQueueThread *m_pPluginQueueThread;
	void vCreatePluginHelpers();
	static bool entityDisconnected;
	static vector<uint64_t> vecReadComplete;
    static avdecc_lib::end_station* getEndStationDesc(uint64_t entity_id);
};
#endif // !defined(CL_PLUGINDATAPROVIDER_H)
