/* ***************************************************************************************
* FILE:          clControlMapping.cpp
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clControlMapping.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY:
* AUTHOR:  Supriya Seshadri(RBEI/ECG5) 07/08/2020
* REVISION:
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "clPluginBase.h"
#include "clControlMapping.h"
#include "plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_PLUGIN_MAIN
#define ETG_I_FILE_PREFIX AVDECCPLUGINS::CONTROLMAPPING::
#include "trcGenProj/Header/clControlMapping.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN


clControlMapping* clControlMapping::poSelf = NULL;
std::multimap<PairEntityDescIndex, PairObjFuncPtr> clControlMapping::m_mapRespCallback = {};

/************************************************************************
*FUNCTION: 		clControlMapping()
*DESCRIPTION: 	Constructor of the class clControlMapping
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	07/05/2020
*************************************************************************/
clControlMapping::clControlMapping()
{
  ETG_TRACE_USR4(("clControlMapping: clControlMapping"));
}

/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION: 	singleton implementation, creates an object of class clControlMapping
*PARAMETER:		None
*RETURNVALUE: 	clControlMapping*
*HISTORY:
*revision 0.1	ess7kor	07/05/2020
*************************************************************************/
clControlMapping* clControlMapping::getInstance()
{
	  ETG_TRACE_USR4(("clControlMapping: getInstance"));

	if (poSelf == NULL)
	{
		poSelf = new (std::nothrow) clControlMapping();
	}
	return poSelf;
}
/************************************************************************
*FUNCTION: 		~clControlMapping()
*DESCRIPTION: 	Destructor of the class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	07/05/2020
*************************************************************************/
// ------------------------------------------------------------------------
clControlMapping::~clControlMapping()
{
	  ETG_TRACE_USR4(("clControlMapping: ~clControlMapping()"));
}

/************************************************************************
*FUNCTION: 		deleteInstance()
*DESCRIPTION: 	singleton implementation, deletes the object of class clControlMapping
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	07/05/2020
*************************************************************************/
void clControlMapping::deleteInstance()
{
	ETG_TRACE_USR4(("clControlMapping: deleteInstance()"));

	if (poSelf != NULL)
	{
		delete poSelf;
		poSelf = NULL;
	}
}

/************************************************************************
*FUNCTION: 		setRespCallBack()
*DESCRIPTION: 	This function is used by the Plugin Helpers to regsiter 
*				for AVDECC Notification Call Backs.
*PARAMETER:		COntrolBlock is the Call back control desc information
*				clPluginBase *pluginptr is the ptr to the Plugin Helper ObjFuncPtr
*				FUNCPTR func is the function pointer to the callback function in 
*				plugin helper class
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	07/05/2020
*************************************************************************/
void clControlMapping::setRespCallBack(std::string strEntityName, int controlblock, clPluginBase *ptr, FUNCPTR func)
{
	ETG_TRACE_USR4(("clControlMapping:setRespCallBack() controlblock: %d, strEntityName is %s", 
	controlblock, strEntityName.c_str()));

	if (ptr != NULL && func != NULL) {
		//Insert the callback details in the multimap 
		//todo controlblock could be a Enum, improvement
		
		m_mapRespCallback.insert(std::pair<PairEntityDescIndex, PairObjFuncPtr>(
			(std::pair<std::string, int>(strEntityName, controlblock)),
			(std::pair<clPluginBase*, FUNCPTR>(ptr, func))
			));
	}
}

/************************************************************************
*FUNCTION: 		getRespCallBack()
*DESCRIPTION: 	This function returns the Call list of PairObjFuncPtr
*				which is registred for a callback when controlblock
*				callback is recieved by the plugin Main.
*PARAMETER:		COntrolBlock is the Call back control desc information
*RETURNVALUE: 	vector<PairObjFuncPtr>
*HISTORY:
*revision 0.1	ess7kor	07/05/2020
*************************************************************************/
vector<PairObjFuncPtr> clControlMapping::getRespCallBack(std::string strEntityName, int controlblock)
{
	
	ETG_TRACE_USR4(("clControlMapping:getRespCallBack() controlblock: %d, strEntityName is %s", 
		controlblock, strEntityName.c_str()));


	vector<PairObjFuncPtr> vecPairObjFuncPtr;
	PairEntityDescIndex mapkey = std::pair<std::string, int>(strEntityName, controlblock);

		if (m_mapRespCallback.count(mapkey) > 0)
		{
			for_each(m_mapRespCallback.begin(), m_mapRespCallback.end(), 
			[&vecPairObjFuncPtr, controlblock, strEntityName]
			(std::pair<PairEntityDescIndex, PairObjFuncPtr> mapvalue)
			{ 
			PairEntityDescIndex itr = mapvalue.first;
			if (itr.first == strEntityName && itr.second == controlblock) {
				vecPairObjFuncPtr.push_back(mapvalue.second); 
					ETG_TRACE_USR4(("Element found\n")); 
			}
			});

		}
		return vecPairObjFuncPtr;
}
/************************************************************************
*FUNCTION: 		getMappingContent()
*DESCRIPTION: 	This function returns the MultiMap of PairEntityDescIndex 
*				and PairObjFuncPtr which is registred for a callback when 
*				controlblock callback is recieved by the plugin Main.
*PARAMETER:		COntrolBlock is the Call back control desc information
*RETURNVALUE: 	multimap<PairEntityDescIndex, PairObjFuncPtr>
*HISTORY:
*revision 0.1	hhd1kor	07/05/2020
*************************************************************************/
std::multimap<PairEntityDescIndex, PairObjFuncPtr> clControlMapping::getMappingContent()
{
	return m_mapRespCallback;
}
/************************************************************************
*FUNCTION: 		getRespCallBackFunc()
*DESCRIPTION: 	This function clears the multimap m_mapRespCallback
*PARAMETER:		COntrolBlock is the Call back control desc information
*RETURNVALUE: 	vector<PairObjFuncPtr>
*HISTORY:
*revision 0.1	ess7kor	07/05/2020
*************************************************************************/
void clControlMapping::clearMappingContent()
{
	m_mapRespCallback.clear();		
}