/*
 * PluginDataType.h
 *
 *  Created on: Oct 23, 2018
 *      Author: uga5kor
 */

#ifndef G3INF4CV_PLUGIN_INC_PLUGINDATATYPE1_H_
#define G3INF4CV_PLUGIN_INC_PLUGINDATATYPE1_H_
#include <stdint.h>
#include <map>
#include "end_station.h"
#include "entity_descriptor.h"
#include "configuration_descriptor.h"
#include "audio_unit_descriptor.h"
#include "stream_input_descriptor.h"
#include "stream_output_descriptor.h"
#include "control_descriptor.h"
using namespace std;
typedef void * (*THREADFUNCPTR)(void *);
typedef void *VOIDPTR;
typedef std::map<std::string, std::string> nameValueMap;

#define CTRLBLOCK_NAME_CAMERA_CONNECT "Connect"
#define CTRLBLOCK_NAME_CAMERA_DISCONNECT "Disconnect"
#define CTRLBLOCK_NAME_CAMERA_SPLITVIEW_SEL "CabinSplitViewSel"

#define CTRLBLOCK_NAME_CAMERA_CAMERA_LIST "CameraListData" 

//#define CTRLBLOCK_NAME_MEDIA_PLAYBACKACTION "Play"

static pthread_mutexattr_t mattr;
static pthread_mutex_t m_thMutexLock;

struct stEntityDesc
{
	//	uint32_t u32EndStationIdx; //extracted from Notification Callback
	//	uint32_t u32EntityIdx; 	//extracted from Notification Callback
	//	uint32_t u32ConfigIdx;	//extracted from Notification Callback	
	uint64_t u64EntityID;	//extracted from Notification Callback
	uint32_t u32EntityIndex; //will be extracted frm the xml based on EntityID
	std::string strEndStationName;   //will be extracted from the xml based on EntityIndex Cameraport_1 etc
	std::string strEntityName;   //will be extracted from the xml based on EntityIndex	CAM, CMP, CMG, 
	avdecc_lib::end_station * end_station;  //Will be extracted based on u32EndStationIdx
	avdecc_lib::entity_descriptor * entity;	//Will be extracted based on u32EntityIdx
	avdecc_lib::configuration_descriptor * configuration;	//Wil be extracted based on u32ConfigIdx
	stEntityDesc()
	{
		u64EntityID = 0;
		u32EntityIndex = 0;
		strEndStationName = "";
		strEntityName = "";
		end_station = NULL;
		entity = NULL;
		configuration = NULL;	
	}
};

struct stCamDesc{
	uint16_t position;
	stEntityDesc CamEntityDesc;
};

struct stEntityDetailsToAppl{
	uint64_t u64EntityID;
	std::string strEntityName;
	bool bConnectionStatus;
};


struct ControlDataElement{
		//const char *cacEntityName;`	
		//uint32_t u32EndStationIdx;
		//uint32_t u32EntityDescIdx;
		//uint32_t u32ConfigDescIdx;
		//std::string strEntityName; //will be extracted from the xml based on EntityIndex	CAMERPORT_1, 
		//avdecc_lib::end_station * end_station;  //Will be extracted based on u32EndStationIdx
		//avdecc_lib::entity_descriptor * entity;	//Will be extracted based on u32EntityIdx
		avdecc_lib::configuration_descriptor * configuration;	//Wil be extracted based on u32ConfigIdx
		uint32_t u32ControlDescIdx; //functionality, plugins will set this
		uint8_t uint8Value;
		uint8_t *puintGetValue;
		uint16_t u16Readlen;
		std::string strGetValue;
};

struct NotificationData {
	uint64_t entity_id;
	uint16_t cmd_type;
	uint16_t desc_index;
};

class ACClientInterface;
enum SourceType
{
 enAudioOnly,
 enVideoOnly,
 enAudioVideo
};
enum Sources
{
CCP_USB1,
CCP_HDMI,
CCP_CAMERAIP,
CMC_CABINOUT,
CMC_MAPOUT,
ANA_CAMERA1,
ANA_CAMERA2,
ANA_CAMERA3,
ANA_CAMERA4,
ANA_CAMERA_OFF,
MAX_SOURCE
};


enum SourceName 
{
	CMP1_USB1,
	CMP1_HDMI,
	CMP1_IPCAM,
	CMP1_CAMERA1,
	CMP1_CAMERA2,
	CMP1_CAMERA3,
	CMP1_CAMERA4,	
	CMP1_SPLITSCREEN,
	CMP2_USB1,
	CMP2_HDMI,
	CMP2_IPCAM,
	CMP2_CAMERA1,
	CMP2_CAMERA2,
	CMP2_CAMERA3,
	CMP2_CAMERA4,
	CMP2_SPLITSCREEN,
	CMP3_USB1,
	CMP3_HDMI,
	CMP3_IPCAM,
	CMP3_CAMERA1,
	CMP3_CAMERA2,
	CMP3_CAMERA3,
	CMP3_CAMERA4,
	CMP3_SPLITSCREEN,
	CMP4_USB1,
	CMP4_HDMI,
	CMP4_IPCAM,
	CMP4_CAMERA1,
	CMP4_CAMERA2,
	CMP4_CAMERA3,
	CMP4_CAMERA4,
	CMP4_SPLITSCREEN,
	MAXSOURCE
};

typedef struct
{
 uint64_t u64Source;
 const unsigned char  caucEntityName[64];
 uint64_t enSourceType;
}stSourceToEntityIDMap;

struct stEntityIDMap
{
  uint64_t u64EnityID;
  unsigned char  caucEntityName[64];
};

struct stEntityDetails
{
  uint64_t u64EntityID;
  unsigned char  entityName[64];
  char entityIp[32];
  char entityMac[64];
  nameValueMap entitySetting;
};

enum AVAllocation
{
 AV1,
 AV2,
 AV3
};

enum InputStream
{
InputStream_0,
InputStream_1,
InputStream_2
};

enum OutputStream
{
OutputStream_0 = 0,
OutputStream_1
};

enum Region
{
REG_A,
REG_B,
REG_COCKPIT,
MAX_REG
};


enum Command_Type{
    AEM_CMD_SET_CONTROL = 24,
    AEM_CMD_GET_CONTROL = 25,
    AEM_CMD_REGISTER_UNSOLICITED_NOTIFICATION = 36
};

struct Command{
	ControlDataElement controlElem;
	Command_Type comType;
	ACClientInterface* clientIf;

};
struct NotificationDataElement{
	int32_t notification_type;
	uint64_t u64Entity_id;
	uint16_t u16Cmd_type;
	uint16_t u16Desc_type;
	uint16_t u16Desc_index;
	uint32_t u32Cmd_status;
};
enum enPlayback_Modes{
        Repeat_Off   = 0,
        Repeat_Track = 1,
        Repeat_List  = 2,
        Shuffle_List = 3
};
enum entFileType{
        entFileType_Video      = 1,
        entFileType_Audio      = 2,
};

#define MEDIA_PLAY 0
#define MEDIA_PAUSE 1
#define MEDIA_PREVIOUS 3
#define MEDIA_NEXT 4
#define MEDIA_SOURCEACTIVE 5     
#define MEDIA_VIDEOSOURCERESTORE 6
#define MEDIA_BROWSE 7
#define FRONT_CHANNEL 1
#define REAR_CHANNEL  2
#define MEDIA_CURRENTTRACKINDEXREQ 0
#define MEDIA_NEXTTRACKINDEXREQ 1
#define MEDIA_PREVTRACKINDEXREQ 2
#define MEDIA_FIRSTTRACKINDEXREQ 3
#define MEDIA_SELECTTRACKINDEXREQ 4

#define TRACKINDEX_UNAVAILABLE 65535
#define MEDIA_LISTTYPE_SONG 3
#define MEDIA_LISTTYPE_VIDEO 26
#define MEDIA_LISTTYPE_INVALID 255
#define MEDIA_LISTTYPE_FOLDER 31
#define MEDIA_DATAPOOL_DEFAULT_AUDIOVIDEO_PLAYBACKMODE 34

//Control id
#define CMR_USB_DB_CRC_UPDATE 42 //for router usb
#define MEDIA_SIGNAL_SOURCE_CHANGE 41 //for cmr
#define MEDIA_USB_DB_CRC_UPDATE 41 //for Camport usb
#define SIGNAL_SOURCE_CHANGE 40 //for cmp
#define CMRSTREAM1_PLAYBACKMODE 43
#define CMRSTREAM3_PLAYBACKMODE 44

#define COACHMEDIA_AMPLIFIER    "CMA"
#define COACHMEDIA_GLASS_A      "CMG"
#define COACHMEDIA_GLASS_B      "CMGB"
#define COACHMEDIA_GLASS_A1     "CMGA1"
#define COACHMEDIA_GLASS_B1     "CMGB1"
#define COACHMEDIA_GLASS_A2     "CMGA2"
#define COACHMEDIA_GLASS_B2     "CMGB2"
#define COACHMEDIA_CAMERAPORT_1 "CMP"
#define COACHMEDIA_INVALID    "INVALID"
#define CABINA_GROUP "group_amp1"
#define CABINB_GROUP "group_amp2"
#define CABINA_GROUP_GLASS "group_glasses1"
#define CABINA2_GROUP_GLASS "group_glasses2"

#define FRONT "front"
#define REAR  "rear"
#define SWIVEL_CALIBRATION 88

#define DEFAULT 0xFFFFFFFFFFFFFFFF
#define MAX_ENTITYMAP 10

#define BEEP_VOLUME 45
#define BEEP_OUTPUT 46

#define CAMPORT_POSITION_UNAVAILABLE 0
#define PRIMARY_CAMPORT 1
#define SECOND_CAMPORT  2
#define THIRD_CAMPORT   3
#define CMP_CAM4_AVDECC_VALUE 8

/****** Start CONTROL DESC INDEX *************/
#define AUDIOCONTROL_STREAM_SELECT 0
#define AUDIOCONTROL_AVB_STREAM 0
#define AUDIOCONTROL_RTP_STREAM 1

#define VOLUMECONTROL_INPUT 14

#define AUDIOCONTROL_CMA_OUTPUT_0 0
#define AUDIOCONTROL_CMA_OUTPUT_1 1
#define AUDIOCONTROL_CMA_OUTPUT_2 2

#define AUDIOCONTROL_CMA_JACKINPUT_0   1
#define AUDIOCONTROL_CMA_STREAMINPUT_0 2
#define AUDIOCONTROL_CMA_STREAMINPUT_1 4


#define AUDIOCONTROL_CCP_STREAMOUTPUT_0_CURRENTTRACK 5
#define AUDIOCONTROL_CCP_STREAMOUTPUT_0_PLAYACION    6
#define AUDIOCONTROL_CCP_STREAMOUTPUT_0_SRC          7

#define AUDIOCONTROL_CCP_STREAMOUTPUT_1_CURRENTTRACK 8
#define AUDIOCONTROL_CCP_STREAMOUTPUT_1_PLAYACION    9
#define AUDIOCONTROL_CCP_STREAMOUTPUT_1_SRC          10

#define AUDIOCONTROL_CCP_ANALOGCAMERA_SEL            13


#define AUDIOCONTROL_CCP_SOURCE_USBVIDEO 0x40
#define AUDIOCONTROL_CCP_SOURCE_IPCAMERA 0x10

#define SETTINGS_SWIVEL_DOWN 0x01
#define SETTINGS_SWIVEL_UP 0x02

#define AUDIOCONTROL_CMA_PRESENTATION 43

#define AUDIOCONTROL_STREAM_NONE 0
#define AUDIOCONTROL_STREAM_AVB 1
#define AUDIOCONTROL_STREAM_RTP 2


#define SWIVEL_UP 2
#define SWIVEL_DOWN 1

#define SWIVEL_AVAILABLE 1
#define SWIVEL_UNAVAILABLE 0

#define MIX_SOURCE_1  8
#define MIX_SOURCE_2  10
#define MIX_SOURCE_3  12
#define CABINACHANNEL1 17
#define CABINACHANNEL2 27
#define CABINACHANNEL3 37

#define MIX_SOURCE_VALUE  0

/*.............*/
#define COMMAND_LCD_OFF 0
#define COMMAND_LCD_ON 1

#define COMMAND_SWIVEL_NONE 0x00
#define COMMAND_SWIVEL_DOWN 0x01
#define COMMAND_SWIVEL_UP 0x02

#define SWIVEL_SELECTED_NONE 0
#define SWIVEL_SELECTED_ONLY_PASSENGER_DOOR 1
#define SWIVEL_SELECTED_ONLY_DRIVER_DOOR 2
#define SWIVEL_SELECTED_ALL_EXCEPT_PASSENGER_DOOR 3
#define SWIVEL_SELECTED_ALL_EXCEPT_DRIVER_DOOR 4
#define SWIVEL_SELECTED_ALL_EXCEPT_DOOR 5
#define SWIVEL_SELECTED_ALL 6

/****** End CONTROL DESC INDEX *************/

#define CONNECTION_FLAGS_CLASSB 0x01
#define CONNECTION_FLAGS_FAST_CONNECT 0x02
#define CONNECTION_FLAGS_SAVED_STATE 0x04
#define CONNECTION_FLAGS_STREAMING_WAIT 0x08
#define CONNECTION_FLAGS_SUPPORTS_ENCRYPTED 0x10
#define CONNECTION_FLAGS_ENCRYPTED_PDU 0x20
#define CONNECTION_FLAGS_TALKER_FAILED 0x40
#define AUDIOCONTROL_CCP_STREAMOUTPUT_TOTALTRACKS 14

#endif /* G3INF4CV_PLUGIN_INC_PLUGINDATATYPE1_H_ */
