/* ***************************************************************************************
* FILE:          clSettingsPlugin.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clSettingsPlugin.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_SETTINGSPLUGIN_H
#define CL_SETTINGSPLUGIN_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"



#include "clPluginBase.h"
#include "PluginDataType.h"
#include "clCommunicationProtocol.h"
#include "PluginConstants.h"
#include "AVRoutingParser.h"



class HandlerRegistration;
class Object;
class Event;

class clSettingsPlugin : public clPluginBase
{

public:
	clSettingsPlugin();
	static clSettingsPlugin* getInstance();	
	static void deleteInstance();
	virtual ~clSettingsPlugin();
	virtual void vEventESReadComplete();
	//Call backs from Plugin
    void vHandleSwivelUpDownStatus(uint16_t cmd_type,uint64_t entity_id);
    void vHandleLCDOnOffStatus(uint16_t cmd_type,uint64_t entity_id);
        void IntializeAttenuationValuesMap();
	void sendfadersettingcommand();
	
	//Event functions
	virtual std::unique_ptr<HandlerRegistration> addPluginEventHandler();
    virtual std::unique_ptr<Event> getPluginEvent(Object* sender, 
												   const std::string msg, 
												   boost::shared_ptr<EventDataUtility> evalue);
    virtual std::unique_ptr<Event> getPluginListEvent(Object* sender,
                                                       const std::string msg,
													   boost::shared_ptr<EventDataUtility>eData,
													   const boost::shared_ptr<EventListDataUtility>& eListData);
													  
	 void setPluginData(std::string key, const boost::shared_ptr<EventDataUtility>& eValue);
     void setPluginListData(std::string key, const boost::shared_ptr<EventDataUtility>& eData,
	 const boost::shared_ptr<EventListDataUtility>& eListData);	
	// Funtion pointers
	 void setMapFuncs();
	 void lcdOnOff(const boost::shared_ptr<EventDataUtility>& eValue);
     void swivelUpDown(const boost::shared_ptr<EventDataUtility>& eValue);
	 
	 void CabinBGlasses(const boost::shared_ptr<EventDataUtility>& eValue);
	 void CabinAGlasses(const boost::shared_ptr<EventDataUtility>& eValue);
	 void UpdateIpAddressToHmi(uint8_t sinkId,std::vector<std::string> ipaddress);
	 void SwivelCalibration(const boost::shared_ptr<EventDataUtility>& eValue);
	 void FaderSetting(const boost::shared_ptr<EventDataUtility>& eValue);
	 void ExtractAttenuationValues(int stepvalue);
	 void vRequestSwivelStatus(uint32_t u32EndStationIdx, uint32_t u32EntityDescIdx, uint32_t u32ConfigDescIdx);
	 bool bFindEntityInList(uint64_t u64EntityID, std::vector<stEntityDesc> MediaGlass, uint32_t &entityIndex);
	 void vRegisterUnSolicitedResponse(ACClientInterface *daemonClient, avdecc_lib::end_station * end_station);
     void vRequestSwivelAvailability(uint32_t u32EndStationIdx, uint32_t u32EntityDescIdx, uint32_t u32ConfigDescIdx);
	 void vExtractESData(std::vector<stEntityDesc> stEntityDetails);
	 void VExtractCabinChannelInfo();
	 void vRegisterPluginCallbacks();
	 bool bFindEntityID(uint64_t u64EntID);
	 std::string sGetEntityCabinName(uint64_t u64EntityID);
	 void updateCMAEntityDetails(std::vector<stEntityDesc> stEntityDetails);
	 void vSetControl(avdecc_lib::configuration_descriptor * configuration, uint32_t u32ControlDescIdx, uint8_t uint8Value);
	
	 //Call backs from HMI Requests
	//void vSetControlUINT8(const char *cacEntityName, uint32_t u32EndStationIdx, uint32_t u32EntityDescIdx, uint32_t u32ConfigDescIdx, uint32_t u32ControlDescIdx, uint8_t uint8Value);
	//void vSetControlUINT8(uint32_t u32ControlDescIdx, uint8_t uint8Value);
//	void vSetControlUINT8(uint32_t u32ControlDescIdx, uint32_t index, uint8_t uint8Value);
        void vSetControlUINT8(uint32_t u32ControlDescIdx, uint64_t entityid, uint8_t uint8Value);

	void vCreateSetControlCommand(uint16_t u16ControlId,uint16_t u16ControlVal);
	
	void sendCommandToLCD(uint8_t sinkId, uint8_t lcdOnOffCommand);
    void sendCommandToSwivel(uint8_t sinkId, uint8_t swivelSelected, uint8_t swivelCommand, uint8_t lcdOnOffCommand);
	void selectEntityBasedOnSink(uint8_t sinkId, std::vector<stEntityDesc>* &mediaGlassList, char* &entityName);
	uint16_t m_u16LastExecutedSetCommand;
	
	ControlDataElement swivelAvailabilityControlElem;
    ControlDataElement swivelStatusControlElem;
	
private:
	clSettingsPlugin(const clSettingsPlugin&);
	clSettingsPlugin& operator =(const clSettingsPlugin&);
	static clSettingsPlugin* poSelf;
	vector<stEntityDesc> m_CMGEntityDetails;
	
	typedef void (clSettingsPlugin::*CAMFUNCPTR)(const boost::shared_ptr<EventDataUtility>&);
    typedef std::map<std::string, CAMFUNCPTR> FuncMap;
    FuncMap m_MemberFunctionMap;
	int32_t m_frontAttenuationValue;
	int32_t m_rearAttenuationValue;
	
	std::vector<stEntityDesc> m_A1MediaGlassList;
    std::vector<stEntityDesc> m_A2MediaGlassList;
    std::vector<stEntityDesc> m_B1MediaGlassList;
    std::vector<stEntityDesc> m_B2MediaGlassList;
	std::vector<std::string> m_CABINAGlasses;
    std::vector<std::string> m_CABINBGlasses;
	std::vector<int> m_CabinAChannelinfo;
	std::vector<int> m_CabinBChannelinfo;
	std::vector <stEntityDesc> m_CMAEntityDetails;
	std::map<int32_t,int32_t> attenationvalues;

    typedef std::map<uint64_t, bool> EntityToSwivelMap;
    EntityToSwivelMap m_IsEntitySwivel;
    typedef std::map<uint64_t, bool> EntityToSwivelDoorMap;
    EntityToSwivelDoorMap m_IsEntityPassengerDoorSwivel;
    EntityToSwivelDoorMap m_IsEntityDriverDoorSwivel;
    typedef std::map<uint64_t, uint8_t> EntityToSwivelStatusMap;
    EntityToSwivelStatusMap m_SwivelStatus;
	
	
	clCommunicationProtocol *m_pCommControl;
	tclEntityInfo *m_pEntityInfo;
    bool m_bParseState = false;
	
};
#endif // !defined(CL_SETTINGSPLUGIN_H)
