/* ***************************************************************************************
* FILE:          clExternalMediaPlayerPlugin.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clExternalMediaPlayerPlugin.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_EXTERNALMEDIAPLAYERPLUGIN_H
#define CL_EXTERNALMEDIAPLAYERPLUGIN_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"

/* Datapool */
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_hmi_11_if.h"
#endif

#include "clPluginBase.h"
#include "PluginDataType.h"
#include "clCommunicationProtocol.h"
#include "PluginConstants.h"

class HandlerRegistration;
class Object;
class Event;


class clExternalMediaPlayerPlugin : public clPluginBase
{

public:
	clExternalMediaPlayerPlugin();
	static clExternalMediaPlayerPlugin* getInstance();	
	static void deleteInstance();
	virtual ~clExternalMediaPlayerPlugin();
	virtual void vEventESReadComplete();
		
	//Event functions
	virtual std::unique_ptr<HandlerRegistration> addPluginEventHandler();
	virtual std::unique_ptr<Event> getPluginEvent(Object* sender, 
												   const std::string msg, 
												   boost::shared_ptr<EventDataUtility> evalue);
	virtual std::unique_ptr<Event> getPluginListEvent(Object* sender,
													   const std::string msg,
													   boost::shared_ptr<EventDataUtility>eData,
													   const boost::shared_ptr<EventListDataUtility>& eListData);
													  
	 void setPluginData(std::string key, const boost::shared_ptr<EventDataUtility>& eValue);
	 void setPluginListData(std::string key, const boost::shared_ptr<EventDataUtility>& eData,
	 const boost::shared_ptr<EventListDataUtility>& eListData);	
	 

	 	void vSetStream1CurrentTrackIndex(uint16_t stream1TrackIndex);
	 void vSetStream3CurrentTrackIndex(uint16_t stream3TrackIndex);
	void vSetStreamCurrentTrackIndex(uint16_t streamTrackIndex,uint16_t Filetype);
	
	//Call backs

private:
	clExternalMediaPlayerPlugin(const clExternalMediaPlayerPlugin&);
	clExternalMediaPlayerPlugin& operator =(const clExternalMediaPlayerPlugin&);
	static clExternalMediaPlayerPlugin* poSelf;
	std::vector <stEntityDesc> m_CMPEntityDetails;
	stEntityDesc m_stPrimCMP;
	stEntityDesc m_stSecCMP;
	stEntityDesc m_stTerCMP;
	std::vector<stCamDesc> m_vecCamDesc;
	stEntityDesc getDetailsOfCMP(uint16_t u16CMP_Pos);
	void vCreateSetControlCommand(uint16_t u16ControlId,uint16_t u16ControlVal);
	void vCreateGetControlCommand(stEntityDesc EntityDescriptor, uint16_t u16ControlId);
	double vConvertTimeInSecs(std::string timevalue);
	avdecc_lib::configuration_descriptor* getConfigurationAndPositon(uint64_t u64Entity_id, uint16_t& u16CMPPosition);
	bool isEntityDescriptorAvailable(stEntityDesc EntityDescriptor);
    void vRegisterCamPort(stEntityDesc EntityDescriptor);
	void vRegisterResponseCallbacks();
	//HMI Function
	void vSendStringResponseToHmi(uint16_t u16DescIndex, std::string strData, uint16_t u16CMPPosition = PRIMARY_CAMPORT);
	void vSendPluginResponseToHmi(uint32_t u32DescIndex, uint8_t uint8Value, uint16_t u16CMPPosition = PRIMARY_CAMPORT);
	
	void vSetStreamFolderCurrentTrackIndex(uint32_t streamTrackIndex,uint16_t Filetype);
	
	//Call backs
	void vStream1PlayactionResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream1RepeatModeResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream3PlayactionResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream1SeekToResponse(uint16_t cmd_type,uint64_t entity_id);
		void vStream3SeekToResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream1CurPlayTimeResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream1TotPlayTimeResponse(uint16_t cmd_type,uint64_t entity_id);
	void vVidNameResponse(uint16_t cmd_type,uint64_t entity_id);
	void vVidEpisodeResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream1CurTrackIndexHighByteResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream1CurTrackIndexLowByteResponse(uint16_t cmd_type,uint64_t entity_id);
	//void vStream3CurTrackIndexResponse();
	void vStream3CurTrackIndexHighByteResponse(uint16_t cmd_type,uint64_t entity_id);
	void vStream3CurTrackIndexLowByteResponse(uint16_t cmd_type,uint64_t entity_id);
		void vStream3CurPlayTimeResponse(uint16_t cmd_type,uint64_t entity_id);
		void vStream3TotPlayTimeResponse(uint16_t cmd_type,uint64_t entity_id);
		void vStream3RepeatModeResponse(uint16_t cmd_type,uint64_t entity_id);
	void vDBStatusResponse(uint16_t cmd_type,uint64_t entity_id);
	void vUSBAudioStatusResponse(uint16_t cmd_type,uint64_t entity_id);
	void vCheckSumStatusResponse(uint16_t cmd_type,uint64_t entity_id);
	void vTrackNameResponse(uint16_t cmd_type,uint64_t entity_id);
	void vHDMIStatusResponse(uint16_t cmd_type,uint64_t entity_id);
	void vHandleAudioVideoPlayBackAction(uint8_t u8ControlId, uint8_t u8PlayAction);
	void vHandlePlaybackAction(std::vector<EventDataItem*> dataItems);
	void vCheckCRCStatus();
	void vHandlePlaybackMode(std::vector<EventDataItem*> dataItems);
	void VReadCMPdatafromdatapool();
	void vClearCMPdatapool();
	void vUsbentitiesupdate();
	void vRenameifInvalidUTF8isFound(std::string &Name);
	void vVideosourcerestoreinpoause();
	void VWritedatapool();
	
	typedef void (clExternalMediaPlayerPlugin::*EMPFUNCPTR)(const boost::shared_ptr<EventDataUtility>&);
	typedef std::map<std::string, EMPFUNCPTR> FuncMap;
	FuncMap m_MemberFunctionMap;
	
	clCommunicationProtocol *m_pCommControl;
	uint16_t m_u16LastExecutedSetCommand;
	uint16_t m_PlayControlId;
	bool m_bPlayAction;
	bool m_bvideosourcerestore;
	
	uint8_t* pValue;
	double m_TotalTimevalue;
	uint8_t m_u8TrackIndex_HighByte;
	uint8_t m_u8TRackIndex_LowByte;
	uint8_t m_u8TrackIndex_Audio_HighByte;
	uint8_t m_u8TRackIndex_Audio_LowByte;
	
	uint8_t m_u8audioStatus;

	std::string m_strCurrentCheckSum;
	std::string m_strPrevCheckSum;
	
	struct PlayBackAction
	{
		uint16_t u8Region;
		uint16_t u8ListType;
		uint16_t u16TrackIndex;
		uint8_t AuidoPLaybackMode;
		uint8_t VideoPLaybackMode;
		uint16_t u16Filter1;
		uint16_t u16Filter2;
		std::string FolderPath;
		uint16_t u16Filetype;
		uint8_t SubSourceType;
	};
	
	PlayBackAction m_CabinTrackInfo;
};
#endif // !defined(CL_EXTERNALMEDIAPLAYERPLUGIN_H)



