#ifndef _TIMESTAMPSYNC_SERVERECHO_H
#define _TIMESTAMPSYNC_SERVERECHO_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          timestampsync_ServiceEcho.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: timestampsync
  * @Template:     FrancaStub.h.tpl
  * @brief         generated file
  *                CCA server
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "org/bosch/cm/incTimeSync/IncTimeSyncStub.h"

#include "asf/stream/MemoryStream.h"

#include "Itimestampsync_ServiceEcho.h"

// timestampsync_ServerEchoInclude: user specific code start
// timestampsync_ServerEchoInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace timestampsync {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::org::bosch::cm::incTimeSync::IncTimeSync;
    using namespace::asf::core;
    using namespace::org::bosch::cm::timestampsync;

    // timestampsync_ServerEchoNameSpace: user specific code start
    // timestampsync_ServerEchoNameSpace: user specific code end

    class timestampsync_tclServerEcho : public Itimestampsync_tclServerEcho
        , private IncTimeSyncStub
        , private TimerCallbackIF
   {
    private:
        DECLARE_CLASS_LOGGER();

    public:
        timestampsync_tclServerEcho(timestampsync_tclAppMain* baseRef);
        virtual ~timestampsync_tclServerEcho();



    public:
        virtual const tChar* getName() const { return "timestampsync_tclServerEcho"; }

        virtual tVoid vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid setTimesyncDataValue(const ::org::bosch::cm::incTimeSync::IncTimeSync::IncTimeStampSyncStruct& timesyncData) {
            IncTimeSyncStub::setTimesyncData(timesyncData);
        }
        virtual tVoid setIncSendStartDelaySecValue(const tS32& incSendStartDelaySec) {
            IncTimeSyncStub::setIncSendStartDelaySec(incSendStartDelaySec);
        }
        virtual tVoid setConfigDataValue(const ::org::bosch::cm::incTimeSync::IncTimeSync::IncTimeStampSyncConfig& configData) {
            IncTimeSyncStub::setConfigData(configData);
        }

        // TimerCallbackIF
        virtual void onExpired(asf::core::Timer                          & timer,
                               boost::shared_ptr <asf::core::TimerPayload> payload);


        // timestampsync_ServerEchoDeclarationsPart: user specific code start
         virtual void OnEchoResponse(tU32 u32SccTime);
         virtual void OnComponentStatus(tBool bActive);
         tVoid parseCommandLine();
         tU32  getStartTime();
         tU16  _u16StartDelaySec;
         tU16  _u16DelaySec;
         tBool _bSyncActive;
         tBool _bResponseReceived;
         tU32  _u32SystemdNotifyTimeMSec;
         Timer _StartTimer;
         Timer _PeriodicTimer;
         Timer _SystemdNotifyTimer;
         timeval _SendTime;
         timeval _ReceiveTime;
        // timestampsync_ServerEchoDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace timestampsync {

#endif // ifndef _TIMESTAMPSYNC_SERVERECHO_H

