/*****************************************************************************
 * @file:         timestampsync_ServiceEcho.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: timestampsync
 * @Template:     FrancaStub.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          CCA server
 *
 * ----------------------------------------------------------------------------
 * @copyright   (C) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "timestampsync_ServiceEcho.h"


// timestampsync_ServerEchoIncludePart: user specific code start
#include <sys/time.h>
#include "Itimestampsync_ClientEcho.h"
#include <systemd/sd-daemon.h> // you also need to add -lsystemd to the linker settings
#include "asf/core/Application.h"
// timestampsync_ServerEchoIncludePart: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_TIMESTAMPSYNC_SERVER_ECHO
#include "trcGenProj/Header/timestampsync_ServiceEcho.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace timestampsync {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::org::bosch::cm::incTimeSync::IncTimeSync;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/Timestampsync/timestampsync_tclServerEcho", timestampsync_tclServerEcho, Info);


timestampsync_tclServerEcho::timestampsync_tclServerEcho(timestampsync_tclAppMain* baseRef)
   : Itimestampsync_tclServerEcho(baseRef)
   , IncTimeSyncStub("echoFiPort")
{
   LOG_INFO("Constructor for timestampsync_tclServerEcho called");
   ETG_TRACE_USR1( ( "Constructor for timestampsync_tclServerEcho called" ) );
   
   // timestampsync_ServerEchotimestampsync_tclServerEcho: user specific code start
   // set default values
   _u16StartDelaySec = 30;
   _u16DelaySec = 10;
   _bSyncActive = TRUE;
   _bResponseReceived = TRUE;
   _u32SystemdNotifyTimeMSec = 10000;

   _SendTime.tv_sec = 0;
   _SendTime.tv_usec = 0;
   _ReceiveTime.tv_sec = 0;
   _ReceiveTime.tv_usec = 0;

   parseCommandLine();

   tU64 u64WatchdogUSec;
   if(sd_watchdog_enabled(0, &u64WatchdogUSec) <= 0) {
      ETG_TRACE_ERR(("Watchdog not enabled"));
   } else {
      _u32SystemdNotifyTimeMSec = (tU32)( u64WatchdogUSec / 1000 ) / 2;
      ETG_TRACE_USR1(("Watchdog timeout = %i ms", _u32SystemdNotifyTimeMSec ));
      _SystemdNotifyTimer.start(* this, _u32SystemdNotifyTimeMSec, ::asf::core::Timer::Once);
   }

   ETG_TRACE_USR1(("Constructor -> sd_notifyf(0, READY=1)"));
   sd_notifyf(0, "READY=1\n"                       // Tells the init system that daemon startup is finished.
                                                   // This is only used by systemd if the service definition file has Type=notify set.
                 "STATUS=Processing requests...\n" // Passes a single-line status string back to the init system that describes the daemon state.
                                                   // This is free-form and can be used for various purposes
                 "MAINPID=%lu\nPARENTID=%lu",
              (unsigned long)getpid(),
              (unsigned long)getppid() );

   ETG_TRACE_USR1(("_u16StartDelaySec = %d", _u16StartDelaySec));
   ETG_TRACE_USR1(("_u16DelaySec      = %d", _u16DelaySec));
   ETG_TRACE_USR1(("_bSyncActive      = %d", _bSyncActive));
   // timestampsync_ServerEchotimestampsync_tclServerEcho: user specific code end
}

timestampsync_tclServerEcho::~timestampsync_tclServerEcho(){
   LOG_INFO("~timestampsync_tclServerEcho called");
   ETG_TRACE_USR1( ( "~timestampsync_tclServerEcho called" ) );
}

// TimerCallbackIF
void timestampsync_tclServerEcho::onExpired(asf::core::Timer& timer, boost::shared_ptr <asf::core::TimerPayload> payload){
   // timestampsync_ServerEchoonExpired: user specific code start
   ETG_TRACE_USR1(("timestampsync_tclServerEcho::onExpired called (act = %d)", timer.getAct()));
   /*
   ETG_TRACE_USR4(("timer _StartTimer         = %d", _StartTimer.getAct()));
   ETG_TRACE_USR4(("timer _PeriodicTimer      = %d", _PeriodicTimer.getAct()));
   ETG_TRACE_USR4(("timer _SystemdNotifyTimer = %d", _SystemdNotifyTimer.getAct()));
   */
   if(&timer == &_StartTimer){
      if(_u16DelaySec > 0) {
         _PeriodicTimer.start(*this, _u16DelaySec * 1000, ::asf::core::Timer::Periodic);
      }
   } else if(&timer == &_PeriodicTimer){
      if(TRUE == _bResponseReceived) {
         I_timestampsync_tclClientEcho* _poIncClientRef;
         _bResponseReceived = FALSE;
         _poIncClientRef = dynamic_cast<I_timestampsync_tclClientEcho*>(_cpoMain->getHandler("I_timestampsync_tclClientEcho"));
         if(_poIncClientRef != NULL) {
            _poIncClientRef->sendECHO((tU8)payload->getRepeatCount());
         }
         if(0 != gettimeofday(&_SendTime, NULL)) {
            ETG_TRACE_FATAL(("timestampsync_tclServerEcho::onExpired: Failed to get gettimeofday for SendTime!!!"));
         }
      }
   } else if(&timer == &_SystemdNotifyTimer){
      ETG_TRACE_USR1(("_SystemdNotifyTimer -> sd_notify(0, WATCHDOG=1)"));
      int ErrNo = sd_notify(0, "WATCHDOG=1");
      if( ErrNo <= 0) {
         ETG_TRACE_FATAL(("Could not send WATCHDOG trigger via sd_notify %d.", ErrNo));
      } else {
         // check if everything is OK. Then restart the timer
         _SystemdNotifyTimer.start(* this, _u32SystemdNotifyTimeMSec, ::asf::core::Timer::Once);
         //ETG_TRACE_USR1(("_SystemdNotifyTimer.getAct() = %d", _SystemdNotifyTimer.getAct()));
      }
   } else {
      ETG_TRACE_FATAL(("unknown timer %d", timer.getAct()));
      ETG_TRACE_FATAL(("timer _StartTimer         = %d", _StartTimer.getAct()));
      ETG_TRACE_FATAL(("timer _PeriodicTimer      = %d", _PeriodicTimer.getAct()));
      ETG_TRACE_FATAL(("timer _SystemdNotifyTimer = %d", _SystemdNotifyTimer.getAct()));
   }
   // timestampsync_ServerEchoonExpired: user specific code end
}



tVoid timestampsync_tclServerEcho::vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg) {
   // timestampsync_ServerEchovHandleMessage: user specific code start
   (tVoid) pMsg;
   // timestampsync_ServerEchovHandleMessage: user specific code end
}

tVoid timestampsync_tclServerEcho::vGetReferences() {
   // timestampsync_ServerEchovGetReferences: user specific code start
   // timestampsync_ServerEchovGetReferences: user specific code end
}

tVoid timestampsync_tclServerEcho::vStartCommunication() {
   // timestampsync_ServerEchovStartCommunication: user specific code start
   // timestampsync_ServerEchovStartCommunication: user specific code end
}

tVoid timestampsync_tclServerEcho::vTraceInfo() {
   // timestampsync_ServerEchovTraceInfo: user specific code start
   // timestampsync_ServerEchovTraceInfo: user specific code end
}

// timestampsync_ServerEchoDefinitioPart: user specific code start
tVoid timestampsync_tclServerEcho::OnComponentStatus(tBool bActive)
{
   ETG_TRACE_USR1(("timestampsync_tclServerEcho::OnComponentStatus called"));
   if(bActive) {
      tU32 StartTimeMs = getStartTime();
      ETG_TRACE_USR1(("StartTimeMs       = %d", StartTimeMs));
      _StartTimer.start(*this, StartTimeMs, ::asf::core::Timer::Once);
   } else {
      _StartTimer.stop();
      _PeriodicTimer.stop();
   }

}

void timestampsync_tclServerEcho::OnEchoResponse(tU32 u32SccTime)
{
   ETG_TRACE_USR1(("timestampsync_tclServerEcho::OnEchoResponse called"));
   _bResponseReceived = TRUE;
   if(0 != gettimeofday(&_ReceiveTime, NULL)) {
      ETG_TRACE_FATAL(("timestampsync_tclServerEcho::OnEchoResponse(): Failed to get gettimeofday for _ReceiveTime!!!"));
   }

   tU32 u32iMxSendTimeMs = (tU32)(_SendTime.tv_sec*1000 + _SendTime.tv_usec/1000);
   tU32 u32iMxReceiveTimeMs = (tU32)(_ReceiveTime.tv_sec*1000 + _ReceiveTime.tv_usec/1000);
   tU32 u32IncResponseTimeMs = u32iMxReceiveTimeMs - u32iMxSendTimeMs;
   // we assume that sending is a bit faster than receiving to if the time difference is odd we use the smaller time
   tU32 u32Scc2AppTimeDifferenceMs = u32SccTime - (u32iMxSendTimeMs + u32IncResponseTimeMs/2);
   ETG_TRACE_FATAL(("timestampsync_tclServerEcho::OnEchoResponse():\nIncResponseTime == %dmsec\nAPP time=%d.%dsec\nSCC time=%d.%dsec\nApp2SccTimeDifference=%d.%dsec",
                    u32IncResponseTimeMs,
                    _ReceiveTime.tv_sec, _ReceiveTime.tv_usec/1000,
                    u32SccTime/1000, u32SccTime%1000,
                    u32Scc2AppTimeDifferenceMs/1000, u32Scc2AppTimeDifferenceMs%1000));
}

// helper functions (for better unit tests
tVoid timestampsync_tclServerEcho::parseCommandLine()
{
   const std::vector <std::string>           arguments = asf::core::Application::getApplication()->getArguments();
   std::vector <std::string>::const_iterator cit;
   ETG_TRACE_USR1(("ArgumentListSize = %i", arguments.size() ));
   int                     count     = 0;
   std::string StartDelaySecKey      = "StartDelaySec=";
   std::string DelaySecKey      = "DelaySec=";
   std::string SyncActiveKey    = "SyncActive=";
   for( cit = arguments.begin(); cit != arguments.end(); cit++){
      count++;
      std::string argument = ( * cit );
      ETG_TRACE_USR1(("Argument%i = %s", count, argument.c_str() ));
      if( argument.compare(StartDelaySecKey) > 0){
         argument     = argument.erase(0, StartDelaySecKey.length() );
         ETG_TRACE_ERR(("StartDelaySecKey = '%s'", argument.c_str() ));
         _u16StartDelaySec = (tU16)atoi(argument.c_str());
      }
      else if( argument.compare(DelaySecKey) > 0){
         argument     = argument.erase(0, DelaySecKey.length() );
         ETG_TRACE_ERR(("DelaySecKey = '%s'", argument.c_str() ));
         _u16DelaySec = (tU16)atoi(argument.c_str());
      }
      else if( argument.compare(SyncActiveKey) > 0){
         argument     = argument.erase(0, SyncActiveKey.length() );
         ETG_TRACE_ERR(("SyncActiveKey = '%s'", argument.c_str() ));
         if(argument.compare("TRUE") > 0) {
            _bSyncActive = TRUE;
         } else {
            _bSyncActive = FALSE;
         }
      }
      else {
         ETG_TRACE_ERR(("Unknown parameter = '%s'", argument.c_str() ));
      }
   }
}

tU32 timestampsync_tclServerEcho::getStartTime()
{
   timeval CurrentTime;
   CurrentTime.tv_sec = 0;
   CurrentTime.tv_usec = 0;
   if(0 != gettimeofday(&CurrentTime, NULL)) {
      ETG_TRACE_FATAL(("timestampsync_tclServerEcho::getStartTime: Failed to get gettimeofday!!!"));
   }

   tU32 u32FirstDelayMs = 1; // if time is already up start the timer for just 1 ms
   if (CurrentTime.tv_sec < _u16StartDelaySec)
   {
      u32FirstDelayMs = (tU32)((_u16StartDelaySec - CurrentTime.tv_sec) * 1000 - CurrentTime.tv_usec/1000);
   }
   return u32FirstDelayMs;
}

// timestampsync_ServerEchoDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace timestampsync {

