/*****************************************************************************
 * @file:         CcaSrvProxy.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: timestampsync
 * @Template:     CcaProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          CCA server
 *
 * ----------------------------------------------------------------------------
 * @copyright   (C) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#include "CcaSrvProxy.h"

namespace org { namespace bosch { namespace cm { namespace timestampsync {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::asf::cca::CcaServerHook;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/timestampsync/CcaSrvProxy", CcaSrvProxy, Info);


CcaSrvProxy::CcaSrvProxy(timestampsync_tclAppMain* baseRef)
   : ICcaSrvProxy(baseRef)
   , CcaServerHookStub()
{
    _poMainRef = baseRef;
   LOG_INFO("Constructor for CcaSrvProxy called");
}

CcaSrvProxy::~CcaSrvProxy(){
   LOG_INFO("~CcaSrvProxy called");
   _poMainRef = NULL;
}

void CcaSrvProxy::onCcaMessage(const::boost::shared_ptr <asf::core::Blob>& request){

      _tclBaseStreamMessage oMyBaseMsg((tU8*)request->getBytes());

      _poMainRef->bDispatchCCAMessages(&oMyBaseMsg);
}

} } } } // namespace org { namespace bosch { namespace cm { namespace timestampsync {
